/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_20_R1.virtual;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.world.entity.Entity;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class VirtualEntity
implements PacketEntity {
    private Entity nmsEntity;
    private int entityId;
    private double renderDistanceSq = 25000.0;
    protected Map<AbstractPlayer, Boolean> players = Maps.newConcurrentMap();
    protected boolean mounted = false;
    protected boolean sendData = false;

    public void setNMSEntity(Entity entity) {
        this.nmsEntity = entity;
        this.entityId = entity.af();
        this.renderDistanceSq = Math.pow(Bukkit.getViewDistance() * 16, 2.0);
    }

    @Override
    public void spawn(Collection<AbstractPlayer> players) {
        for (AbstractPlayer player : players) {
            this.players.put(player, false);
        }
        this.updateRenderedPlayers();
    }

    @Override
    public void spawn(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        this.getNmsEntity().a(this.getNmsEntity().dn(), this.getNmsEntity().dp(), this.getNmsEntity().dt(), this.getNmsEntity().getBukkitYaw(), 0.0f);
        PacketPlayOutSpawnEntity spawnItem = new PacketPlayOutSpawnEntity(this.getNmsEntity());
        PacketPlayOutEntityMetadata data = new PacketPlayOutEntityMetadata(this.getNmsEntity().af(), this.getNmsEntity().aj().c());
        this.sendPacket(new Packet[]{spawnItem, data});
    }

    @Override
    public void update(AbstractLocation location) {
        Entity nmsEntity = this.getNmsEntity();
        this.getNmsEntity().a(location.getX(), location.getY(), location.getZ(), location.getYaw(), 0.0f);
        PacketPlayOutEntityTeleport packetTeleport = null;
        PacketPlayOutEntityMetadata packetData = null;
        if (this.sendData) {
            packetData = new PacketPlayOutEntityMetadata(nmsEntity.af(), nmsEntity.aj().c());
            this.sendData = false;
        }
        if (!this.mounted) {
            packetTeleport = this.createTeleportPacket(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }
        this.sendPacket(new Packet[]{packetData, packetTeleport});
    }

    @Override
    public void destroy(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        this.players.put(target, false);
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{this.getNmsEntity().af()});
        Schedulers.ensureAsync(() -> ((CraftPlayer)player).getHandle().c.a((Packet)destroyPacket));
    }

    @Override
    public void destroy() {
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{this.getNmsEntity().af()});
        for (AbstractPlayer player : this.players.keySet()) {
            ((CraftPlayer)player.getBukkitEntity()).getHandle().c.a((Packet)destroyPacket);
        }
        this.players.clear();
    }

    protected void sendPacket(Packet ... packets) {
        Schedulers.ensureAsync(() -> {
            for (Packet packet : packets) {
                if (packet == null) continue;
                for (AbstractPlayer player : this.players.keySet()) {
                    ((CraftPlayer)player.getBukkitEntity()).getHandle().c.a(packet);
                }
            }
        });
    }

    @Override
    public void updateRenderedPlayers() {
        this.players.replaceAll((player, value) -> {
            double d2 = Math.pow(player.getLocation().getX() - this.nmsEntity.dn(), 2.0) + Math.pow(player.getLocation().getZ() - this.nmsEntity.dt(), 2.0);
            if (value.booleanValue()) {
                if (d2 > this.renderDistanceSq) {
                    this.destroy((AbstractPlayer)player);
                    return false;
                }
            } else if (d2 <= this.renderDistanceSq) {
                this.spawn((AbstractPlayer)player);
                return true;
            }
            return value;
        });
    }

    @Override
    public void addPassenger(PacketEntity entity) {
        PacketPlayOutMount packet = this.createPassengerPacket(entity.getEntityId());
        entity.setMounted(true);
        this.sendPacket(new Packet[]{packet});
    }

    protected PacketPlayOutEntityTeleport createTeleportPacket(double x, double y, double z, float yaw, float pitch) {
        PacketDataSerializer pos = new PacketDataSerializer(Unpooled.buffer());
        pos.d(this.entityId);
        pos.writeDouble(x);
        pos.writeDouble(y);
        pos.writeDouble(z);
        pos.writeByte((int)((byte)(yaw / 360.0f * 255.0f)));
        pos.writeByte(0);
        pos.writeBoolean(false);
        return new PacketPlayOutEntityTeleport(pos);
    }

    public PacketPlayOutMount createPassengerPacket(int passengerId) {
        PacketDataSerializer mount = new PacketDataSerializer(Unpooled.buffer());
        mount.d(this.entityId);
        mount.d(1);
        mount.d(passengerId);
        return new PacketPlayOutMount(mount);
    }

    public PacketPlayOutMount createPassengerPacket(Set<Entity> passengers) {
        PacketDataSerializer mount = new PacketDataSerializer(Unpooled.buffer());
        mount.d(this.entityId);
        mount.d(passengers.size());
        for (Entity ent : passengers) {
            mount.d(ent.af());
        }
        return new PacketPlayOutMount(mount);
    }

    public Entity getNmsEntity() {
        return this.nmsEntity;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setMounted(boolean mounted) {
        this.mounted = mounted;
    }
}

