/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_20_R1.virtual;

import com.mojang.math.Transformation;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.virtual.PacketDisplayItemEntity;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.volatilecode.v1_20_R1.virtual.VirtualEntity;
import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class VirtualDisplayItemEntity
extends VirtualEntity
implements PacketDisplayItemEntity {
    private Display.ItemDisplay displayEntity;
    private PacketDisplayItemEntity.PacketDisplayItemEntityOptions options;
    private AbstractLocation startingLocation;
    private Vector3f displayScale;
    private Vector3f translation;
    private Quaternionf rotationLeft;
    private Quaternionf rotationRight;
    private static final float DEG2RAD = (float)Math.PI / 180;

    public VirtualDisplayItemEntity(AbstractLocation location, PacketDisplayItemEntity.PacketDisplayItemEntityOptions options) {
        this.startingLocation = location;
        this.displayEntity = this.createDisplayEntity(location, options);
        this.setNMSEntity((Entity)this.displayEntity);
        this.options = options;
    }

    private Display.ItemDisplay createDisplayEntity(AbstractLocation location, PacketDisplayItemEntity.PacketDisplayItemEntityOptions options) {
        WorldServer nmsWorld = ((CraftWorld)BukkitAdapter.adapt(location.getWorld())).getHandle();
        this.displayEntity = new Display.ItemDisplay(EntityTypes.ae, (World)nmsWorld);
        this.displayEntity.w(5.0f);
        this.displayEntity.v(5.0f);
        this.displayEntity.a(ItemDisplayContext.f);
        this.displayEntity.a(location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f);
        this.displayEntity.e(true);
        this.displayEntity.a(CraftItemStack.asNMSCopy((ItemStack)options.getItem()));
        this.translation = new Vector3f(0.0f, 0.0f, 0.0f);
        this.rotationLeft = new Quaternionf();
        this.displayScale = new Vector3f((float)options.getScale().getX(), (float)options.getScale().getY(), (float)options.getScale().getZ());
        this.rotationRight = new Quaternionf();
        this.updateTransformation();
        return this.displayEntity;
    }

    private Transformation getTransformation() {
        return new Transformation(this.translation, this.rotationLeft, this.displayScale, this.rotationRight);
    }

    private void updateTransformation() {
        this.displayEntity.a(this.getTransformation());
    }

    @Override
    public void spawn(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        PacketPlayOutSpawnEntity packetSpawn = new PacketPlayOutSpawnEntity(this.getNmsEntity());
        PacketPlayOutEntityMetadata packetData = new PacketPlayOutEntityMetadata(this.getNmsEntity().af(), this.getNmsEntity().aj().c());
        Schedulers.ensureAsync(() -> {
            ClientboundBundlePacket bundle = new ClientboundBundlePacket(Set.of(packetSpawn, packetData));
            ((CraftPlayer)player).getHandle().c.a((Packet)bundle);
        });
    }

    @Override
    public void setItem(ItemStack item) {
        this.displayEntity.a(CraftItemStack.asNMSCopy((ItemStack)item));
        this.sendData = true;
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        this.rotationLeft = new Quaternionf().rotateY(-yaw * ((float)Math.PI / 180)).rotateX(-pitch * ((float)Math.PI / 180));
        this.updateTransformation();
        this.sendData = true;
    }

    @Override
    public void setRotationTransformation(float x, float y, float z) {
        this.rotationRight = new Quaternionf().rotationXYZ(x, y, z);
        this.updateTransformation();
        this.sendData = true;
    }
}

