/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_19_R3.virtual;

import com.mojang.math.Transformation;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.virtual.PacketTextDisplayEntity;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.volatilecode.v1_19_R3.virtual.VirtualEntity;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class VirtualTextDisplayEntity
extends VirtualEntity
implements PacketTextDisplayEntity {
    private Display.TextDisplay displayEntity;
    private PacketTextDisplayEntity.PacketTextDisplayEntityOptions options;
    private Vector3f displayScale;
    private Vector3f translation;
    private Quaternionf rotationLeft;
    private Quaternionf rotationRight;
    private static final float DEG2RAD = (float)Math.PI / 180;

    public VirtualTextDisplayEntity(AbstractLocation location, PacketTextDisplayEntity.PacketTextDisplayEntityOptions options) {
        this.displayEntity = this.createEntity(location, options);
        this.setNMSEntity((Entity)this.displayEntity);
        this.options = options;
    }

    private Display.TextDisplay createEntity(AbstractLocation location, PacketTextDisplayEntity.PacketTextDisplayEntityOptions options) {
        WorldServer nmsWorld = ((CraftWorld)BukkitAdapter.adapt(location.getWorld())).getHandle();
        this.displayEntity = new Display.TextDisplay(EntityTypes.aX, (World)nmsWorld);
        IChatMutableComponent text = IChatBaseComponent.ChatSerializer.a((String)Text.toJson(Text.parse(options.getText())));
        this.displayEntity.y(5.0f);
        this.displayEntity.x(5.0f);
        this.displayEntity.c(1);
        this.displayEntity.b(1);
        this.displayEntity.c(options.getBackgroundColor().asARGB());
        this.displayEntity.c((IChatBaseComponent)text);
        this.displayEntity.a(Display.BillboardConstraints.valueOf((String)options.getBillboard().toString()));
        this.displayEntity.a(location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f);
        this.displayEntity.e(true);
        this.translation = new Vector3f(0.0f, 0.0f, 0.0f);
        this.rotationLeft = new Quaternionf();
        this.displayScale = new Vector3f((float)options.getScale().getX(), (float)options.getScale().getY(), (float)options.getScale().getZ());
        this.rotationRight = new Quaternionf();
        this.updateTransformation();
        return this.displayEntity;
    }

    private Transformation getTransformation() {
        return new Transformation(this.translation, this.rotationLeft, this.displayScale, this.rotationRight);
    }

    private void updateTransformation() {
        this.displayEntity.a(this.getTransformation());
    }

    @Override
    public void spawn(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        PacketPlayOutSpawnEntity packetSpawn = new PacketPlayOutSpawnEntity(this.getNmsEntity());
        PacketPlayOutEntityMetadata packetData = new PacketPlayOutEntityMetadata(this.getNmsEntity().af(), this.getNmsEntity().aj().c());
        Schedulers.ensureAsync(() -> {
            ((CraftPlayer)player).getHandle().b.a((Packet)packetSpawn);
            ((CraftPlayer)player).getHandle().b.a((Packet)packetData);
        });
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        this.rotationLeft = new Quaternionf().rotateY(-yaw * ((float)Math.PI / 180)).rotateX(-pitch * ((float)Math.PI / 180));
        this.updateTransformation();
    }
}

