/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_19_R3;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.mobs.MobSpawnCategory;
import io.lumine.mythic.api.spawning.MythicSpawnState;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileSpawningHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.SpawnerCreature;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftSpawnCategory;
import org.bukkit.entity.SpawnCategory;

public class VolatileSpawningHandlerImpl
implements VolatileSpawningHandler {
    static final int MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);
    public Map<String, WrappedMobCategory> categories = Maps.newConcurrentMap();

    public VolatileSpawningHandlerImpl(VolatileCodeHandler handler) {
        for (EnumCreatureType cat : EnumCreatureType.values()) {
            this.categories.put(cat.name().toUpperCase(), new WrappedMobCategory(cat));
        }
    }

    @Override
    public MythicSpawnState getSpawnState(AbstractWorld world) {
        World bukkitWorld = BukkitAdapter.adapt(world);
        WorldServer nmsWorld = ((CraftWorld)bukkitWorld).getHandle();
        int chunkCount = nmsWorld.k().a.j().b();
        SpawnerCreature.d spawnState = nmsWorld.k().n();
        int limit = 0;
        EnumCreatureType mobCategory = EnumCreatureType.a;
        SpawnCategory spawnCategory = CraftSpawnCategory.toBukkit((EnumCreatureType)mobCategory);
        if (CraftSpawnCategory.isValidForLimits((SpawnCategory)spawnCategory)) {
            limit = nmsWorld.getWorld().getSpawnLimit(spawnCategory);
        }
        int spawnableChunkCount = spawnState == null ? 0 : spawnState.a();
        ConcurrentMap categories = spawnState == null ? Maps.newConcurrentMap() : spawnState.b();
        int mobCap = limit * spawnableChunkCount / MAGIC_NUMBER;
        return new WrappedSpawnState(world, chunkCount, mobCap, categories);
    }

    @Override
    public byte getSpawnRange(AbstractWorld world) {
        World bukkitWorld = BukkitAdapter.adapt(world);
        WorldServer nmsWorld = ((CraftWorld)bukkitWorld).getHandle();
        return (byte)(nmsWorld.spigotConfig.mobSpawnRange - 1);
    }

    public static class WrappedMobCategory
    implements MobSpawnCategory {
        private final EnumCreatureType nmsCategory;

        public WrappedMobCategory(EnumCreatureType category) {
            this.nmsCategory = category;
        }

        @Override
        public String getName() {
            return this.nmsCategory.a();
        }

        public EnumCreatureType toNMS() {
            return this.nmsCategory;
        }
    }

    public static class WrappedSpawnState
    implements MythicSpawnState {
        private final AbstractWorld world;
        private final int spawnableChunkCount;
        private final int maxMobCount;
        private final Map<EnumCreatureType, Integer> mobCount;

        @Override
        public Collection<MobSpawnCategory> getCategories() {
            ArrayList cats = Lists.newArrayList();
            for (EnumCreatureType cat : this.mobCount.keySet()) {
                cats.add(new WrappedMobCategory(cat));
            }
            return cats;
        }

        @Override
        public Map<MobSpawnCategory, Integer> getCurrentMobCounts() {
            ConcurrentMap map = Maps.newConcurrentMap();
            for (Map.Entry<EnumCreatureType, Integer> entry : this.mobCount.entrySet()) {
                map.put(new WrappedMobCategory(entry.getKey()), entry.getValue());
            }
            return map;
        }

        @Override
        public int getCurrentMobCount(MobSpawnCategory category) {
            EnumCreatureType nmsCategory = ((WrappedMobCategory)category).toNMS();
            return this.mobCount.getOrDefault(nmsCategory, 0);
        }

        @Override
        public int getMonsterCount() {
            return this.mobCount.getOrDefault(EnumCreatureType.a, 0);
        }

        public WrappedSpawnState(AbstractWorld world, int spawnableChunkCount, int maxMobCount, Map<EnumCreatureType, Integer> mobCount) {
            this.world = world;
            this.spawnableChunkCount = spawnableChunkCount;
            this.maxMobCount = maxMobCount;
            this.mobCount = mobCount;
        }

        @Override
        public AbstractWorld getWorld() {
            return this.world;
        }

        @Override
        public int getSpawnableChunkCount() {
            return this.spawnableChunkCount;
        }

        @Override
        public int getMaxMobCount() {
            return this.maxMobCount;
        }

        public Map<EnumCreatureType, Integer> getMobCount() {
            return this.mobCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrappedSpawnState)) {
                return false;
            }
            WrappedSpawnState other = (WrappedSpawnState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSpawnableChunkCount() != other.getSpawnableChunkCount()) {
                return false;
            }
            if (this.getMaxMobCount() != other.getMaxMobCount()) {
                return false;
            }
            AbstractWorld this$world = this.getWorld();
            AbstractWorld other$world = other.getWorld();
            if (this$world == null ? other$world != null : !((Object)this$world).equals(other$world)) {
                return false;
            }
            Map<EnumCreatureType, Integer> this$mobCount = this.getMobCount();
            Map<EnumCreatureType, Integer> other$mobCount = other.getMobCount();
            return !(this$mobCount == null ? other$mobCount != null : !((Object)this$mobCount).equals(other$mobCount));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WrappedSpawnState;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSpawnableChunkCount();
            result = result * 59 + this.getMaxMobCount();
            AbstractWorld $world = this.getWorld();
            result = result * 59 + ($world == null ? 43 : $world.hashCode());
            Map<EnumCreatureType, Integer> $mobCount = this.getMobCount();
            result = result * 59 + ($mobCount == null ? 43 : ((Object)$mobCount).hashCode());
            return result;
        }

        public String toString() {
            return "VolatileSpawningHandlerImpl.WrappedSpawnState(world=" + this.getWorld() + ", spawnableChunkCount=" + this.getSpawnableChunkCount() + ", maxMobCount=" + this.getMaxMobCount() + ", mobCount=" + this.getMobCount() + ")";
        }
    }
}

