/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_19_R2.ai.goals;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.ai.WrappedPathfindingGoal;
import io.lumine.mythic.core.utils.annotations.MythicAIGoal;
import io.lumine.mythic.core.volatilecode.v1_19_R2.ai.PathfinderHolder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import org.bukkit.entity.Entity;

@MythicAIGoal(name="fleeFaction", aliases={"runFromFaction"}, description="Runs away from nearby entities that is in a specific faction")
public class FleeFactionGoal
extends WrappedPathfindingGoal
implements PathfinderHolder {
    protected float distance;
    protected double speed;
    protected double safeSpeed;
    private Set<String> faction = Sets.newHashSet();

    public FleeFactionGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
        String[] split;
        this.distance = mlc.getFloat(new String[]{"distance", "d"}, 16.0f);
        this.speed = mlc.getDouble(new String[]{"speed", "s"}, (double)1.2f);
        this.safeSpeed = mlc.getDouble(new String[]{"safespeed", "ss"}, 1.0);
        String factions = mlc.getString(new String[]{"faction", "f"}, this.dataVar1, new String[0]);
        if (factions == null) {
            return;
        }
        for (String s2 : split = factions.split(",")) {
            this.faction.add(s2.toUpperCase());
        }
    }

    @Override
    public boolean isValid() {
        return this.entity.isCreature();
    }

    @Override
    public PathfinderGoal create() {
        return new PathfinderGoalAvoidTarget(PathfinderHolder.getNMSEntity(this.entity), EntityLiving.class, this.distance, this.safeSpeed, this.speed, targetEntity -> {
            try {
                ActiveMob am = FleeFactionGoal.getPlugin().getMobManager().getMythicMobInstance(this.getEntity());
                AbstractEntity target = BukkitAdapter.adapt((Entity)((EntityLiving)targetEntity).getBukkitEntity());
                if (am == null) {
                    return false;
                }
                if (target.isPlayer()) {
                    for (String faction : this.faction) {
                        if (!FleeFactionGoal.getPlugin().getPlayerManager().getFactionProvider().isInFaction(target.asPlayer(), faction)) continue;
                        return true;
                    }
                } else {
                    Optional<ActiveMob> maybeTargetAM = FleeFactionGoal.getPlugin().getMobManager().getActiveMob(target.getUniqueId());
                    if (!maybeTargetAM.isPresent()) {
                        return false;
                    }
                    ActiveMob targetAM = maybeTargetAM.get();
                    if (targetAM.hasFaction()) {
                        String faction = targetAM.getFaction().toUpperCase();
                        return this.faction.contains(faction);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        });
    }
}

