/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_19_R1_2.virtual;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.volatilecode.virtual.PacketFallingBlock;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.reflection.Reflector;
import io.lumine.mythic.core.volatilecode.v1_19_R1_2.virtual.VirtualEntity;
import java.lang.reflect.Constructor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBell;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class VirtualFallingBlock
extends VirtualEntity
implements PacketFallingBlock {
    private static Constructor<?> refFallingBlock;
    private final BlockData blockData;
    private EntityFallingBlock blockEntity;

    public VirtualFallingBlock(BlockData blockData, AbstractLocation location) {
        this.blockData = blockData;
        this.blockEntity = this.createBlockEntity(blockData, location);
        this.blockEntity.e(true);
        this.setNMSEntity((Entity)this.blockEntity);
    }

    private EntityFallingBlock createBlockEntity(BlockData blockData, AbstractLocation location) {
        WorldServer nmsWorld = ((CraftWorld)BukkitAdapter.adapt(location.getWorld())).getHandle();
        IBlockData blockState = ((CraftBlockData)blockData).getState();
        try {
            return (EntityFallingBlock)refFallingBlock.newInstance(nmsWorld, location.getX() + 0.5, location.getY() + 0.5, location.getZ() + 0.5, blockState);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void spawn(AbstractPlayer target) {
        IBlockData blockState = ((CraftBlockData)this.blockData).getState();
        Player player = BukkitAdapter.adapt(target);
        this.getNmsEntity().a(this.getNmsEntity().df(), this.getNmsEntity().dh(), this.getNmsEntity().dl(), 0.0f, 0.0f);
        PacketPlayOutSpawnEntity spawnItem = new PacketPlayOutSpawnEntity((Entity)this.blockEntity, BlockBell.i((IBlockData)blockState), this.blockEntity.h());
        PacketPlayOutEntityMetadata data = new PacketPlayOutEntityMetadata(this.blockEntity.ae(), this.getNmsEntity().ai(), true);
        Schedulers.async().run(() -> {
            ((CraftPlayer)player).getHandle().b.a((Packet)spawnItem);
            ((CraftPlayer)player).getHandle().b.a((Packet)data);
        });
    }

    @Override
    public void update(AbstractLocation location) {
        Entity nmsEntity = this.getNmsEntity();
        double currentX = nmsEntity.df();
        double currentY = nmsEntity.dh();
        double currentZ = nmsEntity.dl();
        double newX = location.getX() + 0.5;
        double newY = location.getY() + 0.5;
        double newZ = location.getZ() + 0.5;
        this.getNmsEntity().a(newX, newY, newZ, 0.0f, 0.0f);
        double distance = Math.pow(newX - currentX, 2.0) + Math.pow(newY - currentY, 2.0) + Math.pow(newZ - currentZ, 2.0);
        if (distance < 64.0) {
            AbstractVector currentVector = new AbstractVector(currentX, currentY, currentZ);
            AbstractVector newVector = new AbstractVector(newX, newY, newZ);
            AbstractVector velocity = newVector.subtract(currentVector).multiply(1);
            PacketPlayOutEntityVelocity packetV = new PacketPlayOutEntityVelocity(nmsEntity.ae(), new Vec3D(velocity.getX(), velocity.getY(), velocity.getZ()));
            Schedulers.async().run(() -> {
                for (AbstractPlayer player : this.players.keySet()) {
                    ((CraftPlayer)player.getBukkitEntity()).getHandle().b.a((Packet)packetV);
                }
            });
        } else {
            this.blockEntity.b(location.getX(), location.getY(), location.getZ());
            PacketPlayOutEntityMetadata packetData = new PacketPlayOutEntityMetadata(nmsEntity.ae(), this.blockEntity.ai(), true);
            PacketPlayOutEntityTeleport packetTeleport = new PacketPlayOutEntityTeleport(nmsEntity);
            Schedulers.async().run(() -> {
                for (AbstractPlayer player : this.players.keySet()) {
                    ((CraftPlayer)player.getBukkitEntity()).getHandle().b.a((Packet)packetData);
                    ((CraftPlayer)player.getBukkitEntity()).getHandle().b.a((Packet)packetTeleport);
                }
            });
        }
    }

    @Override
    public void destroy(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        this.players.remove(player);
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{this.blockEntity.ae()});
        Schedulers.async().run(() -> ((CraftPlayer)player).getHandle().b.a((Packet)destroyPacket));
    }

    @Override
    public void destroy() {
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{this.blockEntity.ae()});
        for (AbstractPlayer player : this.players.keySet()) {
            Schedulers.async().run(() -> ((CraftPlayer)player.getBukkitEntity()).getHandle().b.a((Packet)destroyPacket));
        }
        this.players.clear();
    }

    static {
        try {
            refFallingBlock = Reflector.getConstructor(EntityFallingBlock.class, World.class, Double.class, Double.class, Double.class, IBlockData.class);
            refFallingBlock.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

