/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_19_R1_2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.mobs.MobSpawnCategory;
import io.lumine.mythic.api.spawning.MythicSpawnState;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileSpawningHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.reflection.Reflector;
import io.lumine.mythic.core.mobs.ActiveMob;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.QuartPos;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.SpawnerCreatureProbabilities;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftSpawnCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SpawnCategory;

public class VolatileSpawningHandlerImpl
implements VolatileSpawningHandler {
    static final int MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);
    private Reflector<SpawnerCreature.d> refSpawnState = new Reflector<SpawnerCreature.d>(SpawnerCreature.d.class, "a", "b", "c", "d", "e", "h");
    private Constructor cSpawnState = null;
    private Method refCanSpawn = null;
    private Method refGetBiome = null;
    private Method refAfterSpawn = null;
    private Method refGetVisibleChunkIfPresent = null;
    public Map<String, WrappedMobCategory> categories = Maps.newConcurrentMap();

    public VolatileSpawningHandlerImpl(VolatileCodeHandler handler) {
        for (EnumCreatureType cat : EnumCreatureType.values()) {
            this.categories.put(cat.name().toUpperCase(), new WrappedMobCategory(cat));
        }
        try {
            this.cSpawnState = Reflector.getConstructor(SpawnerCreature.d.class, Integer.class, Object2IntOpenHashMap.class, SpawnerCreatureProbabilities.class, LocalMobCapCalculator.class);
            this.refCanSpawn = Reflector.getMethod(SpawnerCreature.d.class, "a", EntityTypes.class, BlockPosition.class, IChunkAccess.class);
            this.refGetBiome = Reflector.getMethod(SpawnerCreature.class, "a", BlockPosition.class, IChunkAccess.class);
            this.refAfterSpawn = Reflector.getMethod(SpawnerCreature.d.class, "a", EntityInsentient.class, IChunkAccess.class);
            this.refGetVisibleChunkIfPresent = Reflector.getMethod(ChunkProviderServer.class, "b", Long.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public MythicSpawnState getSpawnState(AbstractWorld world) {
        org.bukkit.World bukkitWorld = BukkitAdapter.adapt(world);
        WorldServer nmsWorld = ((CraftWorld)bukkitWorld).getHandle();
        int chunkCount = nmsWorld.k().a.i().b();
        SpawnerCreature.d spawnState = nmsWorld.k().m();
        int limit = 0;
        EnumCreatureType mobCategory = EnumCreatureType.a;
        SpawnCategory spawnCategory = CraftSpawnCategory.toBukkit((EnumCreatureType)mobCategory);
        if (CraftSpawnCategory.isValidForLimits((SpawnCategory)spawnCategory)) {
            limit = nmsWorld.getWorld().getSpawnLimit(spawnCategory);
        }
        int spawnableChunkCount = spawnState == null ? 0 : spawnState.a();
        ConcurrentMap categories = spawnState == null ? Maps.newConcurrentMap() : spawnState.b();
        int mobCap = limit * spawnableChunkCount / MAGIC_NUMBER;
        return new WrappedSpawnState(world, chunkCount, mobCap, categories);
    }

    @Override
    public byte getSpawnRange(AbstractWorld world) {
        org.bukkit.World bukkitWorld = BukkitAdapter.adapt(world);
        WorldServer nmsWorld = ((CraftWorld)bukkitWorld).getHandle();
        return (byte)(nmsWorld.spigotConfig.mobSpawnRange - 1);
    }

    private BlockPosition getRandomPosWithin(World world, net.minecraft.world.level.chunk.Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        int i = chunkcoordintpair.d() + world.w.a(16);
        int j = chunkcoordintpair.e() + world.w.a(16);
        int k = chunk.a(HeightMap.Type.b, i, j) + 1;
        int l = MathHelper.b((RandomSource)world.w, (int)world.u_(), (int)k);
        return new BlockPosition(i, l, j);
    }

    public boolean canSpawnAtLocation(AbstractLocation location) {
        try {
            Location bukkitLocation = BukkitAdapter.adapt(location);
            BlockPosition nmsLocation = new BlockPosition(location.getX(), location.getY(), location.getZ());
            Chunk bukkitChunk = bukkitLocation.getChunk();
            org.bukkit.World bukkitWorld = bukkitChunk.getWorld();
            net.minecraft.world.level.chunk.Chunk nmsChunk = ((CraftChunk)bukkitChunk).getHandle();
            WorldServer nmsWorld = ((CraftWorld)bukkitWorld).getHandle();
            int chunkCount = nmsWorld.k().a.i().b();
            ChunkGetter inter = (i, consumer) -> {
                try {
                    PlayerChunk playerchunk = (PlayerChunk)this.refGetVisibleChunkIfPresent.invoke((Object)nmsWorld.k(), i);
                    if (playerchunk != null) {
                        playerchunk.c().getNow(PlayerChunk.c).left().ifPresent(consumer);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            };
            Log.info("ChunkCount {0}", chunkCount);
            SpawnerCreature.d spawnState = nmsWorld.k().m();
            EnumCreatureType mobCategory = EnumCreatureType.a;
            SpawnCategory spawnCategory = CraftSpawnCategory.toBukkit((EnumCreatureType)mobCategory);
            boolean spawnThisTick = false;
            int limit = 0;
            if (CraftSpawnCategory.isValidForLimits((SpawnCategory)spawnCategory)) {
                spawnThisTick = nmsWorld.ticksPerSpawnCategory.getLong((Object)spawnCategory) != 0L && nmsWorld.U() % nmsWorld.ticksPerSpawnCategory.getLong((Object)spawnCategory) == 0L;
                limit = nmsWorld.getWorld().getSpawnLimit(spawnCategory);
            }
            if (!spawnThisTick) {
                return false;
            }
            Log.info("Spawn Limit {0}", limit);
            if (limit == 0) {
                return false;
            }
            int i2 = limit * spawnState.a() / MAGIC_NUMBER;
            LocalMobCapCalculator localMobCap = (LocalMobCapCalculator)this.refSpawnState.get(spawnState, "e");
            int categoryCount = spawnState.b().getInt((Object)mobCategory);
            boolean localCanSpawn = localMobCap == null ? true : localMobCap.a(mobCategory, nmsChunk.f());
            Log.info("i {0}", i2);
            Log.info("Spawnable Chunk Count {0}", spawnState.a());
            Log.info("Cat Count {0}", categoryCount);
            Log.info("LocalSpawn {0}", localCanSpawn);
            BiomeSettingsMobs.b biomeSettings = ((BiomeBase)this.refGetBiome.invoke(null, nmsLocation, nmsChunk)).b().a(EntityTypes.bj);
            if (biomeSettings != null) {
                Log.info("Charge {0}", biomeSettings.b());
                Log.info("Biome Budget {0}", biomeSettings.a());
            }
            double lastCharge = (Double)this.refSpawnState.get(spawnState, "h");
            SpawnerCreatureProbabilities potentialCalc = (SpawnerCreatureProbabilities)this.refSpawnState.get(spawnState, "c");
            Log.info("last charge {0}", lastCharge);
            Log.info("Change {0}", potentialCalc.b(nmsLocation, lastCharge));
            if (localMobCap != null) {
                Log.info("localcap can spawn {0}", localMobCap.a(EnumCreatureType.a, nmsChunk.f()));
            }
            return categoryCount >= i2 ? false : localCanSpawn;
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void testSpawnState() {
    }

    public void trackSpawnedMob(ActiveMob mob) {
        if (!mob.getEntity().isMob()) {
            Log.info("no");
            return;
        }
        Entity bukkitEntity = mob.getEntity().getBukkitEntity();
        Location bukkitLocation = bukkitEntity.getLocation();
        Chunk bukkitChunk = bukkitLocation.getChunk();
        org.bukkit.World bukkitWorld = bukkitChunk.getWorld();
        EntityInsentient nmsEntity = (EntityInsentient)((CraftEntity)bukkitEntity).getHandle();
        net.minecraft.world.level.chunk.Chunk nmsChunk = ((CraftChunk)bukkitChunk).getHandle();
        WorldServer nmsWorld = ((CraftWorld)bukkitWorld).getHandle();
        SpawnerCreature.d spawnState = nmsWorld.k().m();
        try {
            this.refAfterSpawn.invoke((Object)spawnState, nmsEntity, nmsChunk);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        EnumCreatureType mobCategory = EnumCreatureType.a;
        SpawnCategory spawnCategory = CraftSpawnCategory.toBukkit((EnumCreatureType)mobCategory);
        int categoryCount = spawnState.b().getInt((Object)mobCategory);
        int limit = 0;
        if (CraftSpawnCategory.isValidForLimits((SpawnCategory)spawnCategory)) {
            limit = nmsWorld.getWorld().getSpawnLimit(spawnCategory);
        }
        Log.info("Spawn Limit {0}", limit);
        Log.info("Cat Count {0}", categoryCount);
    }

    public void createState(Iterable<net.minecraft.world.entity.Entity> iterable, ChunkGetter spawnercreature_b) {
        SpawnerCreatureProbabilities spawnercreatureprobabilities = new SpawnerCreatureProbabilities();
        Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
        Iterator<net.minecraft.world.entity.Entity> iterator = iterable.iterator();
        Log.info("Creating spawn state");
        while (iterator.hasNext()) {
            EnumCreatureType enumcreaturetype;
            net.minecraft.world.entity.Entity entity = iterator.next();
            Log.info("[SpawnState] Entity {0} - {1}", entity.X(), entity.co());
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                if (entityinsentient.h(0.0)) {
                    Log.info("-- State CC");
                    continue;
                }
                if (entityinsentient.fr()) {
                    Log.info("-- State AA");
                    continue;
                }
                if (entityinsentient.P()) {
                    Log.info("-- State BB");
                    continue;
                }
            }
            if ((enumcreaturetype = entity.ad().f()) != EnumCreatureType.h) {
                BlockPosition blockposition = entity.da();
                spawnercreature_b.query(ChunkCoordIntPair.a((BlockPosition)blockposition), chunk -> {
                    BiomeSettingsMobs.b biomesettingsmobs_b = VolatileSpawningHandlerImpl.getRoughBiome(blockposition, (IChunkAccess)chunk).b().a(entity.ad());
                    if (biomesettingsmobs_b != null) {
                        Log.info("-- biome not null, charge {0}", biomesettingsmobs_b.b());
                        spawnercreatureprobabilities.a(entity.da(), biomesettingsmobs_b.b());
                    }
                    if (!(entity instanceof EntityInsentient)) {
                        Log.info("-- not mob");
                    }
                    Log.info("-- add as {0}", enumcreaturetype);
                    object2intopenhashmap.addTo((Object)enumcreaturetype, 1);
                });
                continue;
            }
            Log.info("-- State MISC");
        }
        Log.info("intmap " + object2intopenhashmap.toString());
    }

    static BiomeBase getRoughBiome(BlockPosition blockposition, IChunkAccess ichunkaccess) {
        return (BiomeBase)ichunkaccess.getNoiseBiome(QuartPos.a((int)blockposition.u()), QuartPos.a((int)blockposition.v()), QuartPos.a((int)blockposition.w())).a();
    }

    public static class WrappedMobCategory
    implements MobSpawnCategory {
        private final EnumCreatureType nmsCategory;

        public WrappedMobCategory(EnumCreatureType category) {
            this.nmsCategory = category;
        }

        @Override
        public String getName() {
            return this.nmsCategory.a();
        }

        public EnumCreatureType toNMS() {
            return this.nmsCategory;
        }
    }

    public static class WrappedSpawnState
    implements MythicSpawnState {
        private final AbstractWorld world;
        private final int spawnableChunkCount;
        private final int maxMobCount;
        private final Map<EnumCreatureType, Integer> mobCount;

        @Override
        public Collection<MobSpawnCategory> getCategories() {
            ArrayList cats = Lists.newArrayList();
            for (EnumCreatureType cat : this.mobCount.keySet()) {
                cats.add(new WrappedMobCategory(cat));
            }
            return cats;
        }

        @Override
        public Map<MobSpawnCategory, Integer> getCurrentMobCounts() {
            ConcurrentMap map = Maps.newConcurrentMap();
            for (Map.Entry<EnumCreatureType, Integer> entry : this.mobCount.entrySet()) {
                map.put(new WrappedMobCategory(entry.getKey()), entry.getValue());
            }
            return map;
        }

        @Override
        public int getCurrentMobCount(MobSpawnCategory category) {
            EnumCreatureType nmsCategory = ((WrappedMobCategory)category).toNMS();
            return this.mobCount.getOrDefault(nmsCategory, 0);
        }

        @Override
        public int getMonsterCount() {
            return this.mobCount.getOrDefault(EnumCreatureType.a, 0);
        }

        public WrappedSpawnState(AbstractWorld world, int spawnableChunkCount, int maxMobCount, Map<EnumCreatureType, Integer> mobCount) {
            this.world = world;
            this.spawnableChunkCount = spawnableChunkCount;
            this.maxMobCount = maxMobCount;
            this.mobCount = mobCount;
        }

        @Override
        public AbstractWorld getWorld() {
            return this.world;
        }

        @Override
        public int getSpawnableChunkCount() {
            return this.spawnableChunkCount;
        }

        @Override
        public int getMaxMobCount() {
            return this.maxMobCount;
        }

        public Map<EnumCreatureType, Integer> getMobCount() {
            return this.mobCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrappedSpawnState)) {
                return false;
            }
            WrappedSpawnState other = (WrappedSpawnState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSpawnableChunkCount() != other.getSpawnableChunkCount()) {
                return false;
            }
            if (this.getMaxMobCount() != other.getMaxMobCount()) {
                return false;
            }
            AbstractWorld this$world = this.getWorld();
            AbstractWorld other$world = other.getWorld();
            if (this$world == null ? other$world != null : !((Object)this$world).equals(other$world)) {
                return false;
            }
            Map<EnumCreatureType, Integer> this$mobCount = this.getMobCount();
            Map<EnumCreatureType, Integer> other$mobCount = other.getMobCount();
            return !(this$mobCount == null ? other$mobCount != null : !((Object)this$mobCount).equals(other$mobCount));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WrappedSpawnState;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSpawnableChunkCount();
            result = result * 59 + this.getMaxMobCount();
            AbstractWorld $world = this.getWorld();
            result = result * 59 + ($world == null ? 43 : $world.hashCode());
            Map<EnumCreatureType, Integer> $mobCount = this.getMobCount();
            result = result * 59 + ($mobCount == null ? 43 : ((Object)$mobCount).hashCode());
            return result;
        }

        public String toString() {
            return "VolatileSpawningHandlerImpl.WrappedSpawnState(world=" + this.getWorld() + ", spawnableChunkCount=" + this.getSpawnableChunkCount() + ", maxMobCount=" + this.getMaxMobCount() + ", mobCount=" + this.getMobCount() + ")";
        }
    }

    @FunctionalInterface
    public static interface ChunkGetter {
        public void query(long var1, Consumer<net.minecraft.world.level.chunk.Chunk> var3);
    }
}

