/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_18_R2.virtual;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Map;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.world.entity.Entity;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class VirtualEntity
implements PacketEntity {
    private Entity nmsEntity;
    private int entityId;
    private double renderDistanceSq = 25000.0;
    protected Map<AbstractPlayer, Boolean> players = Maps.newConcurrentMap();
    protected boolean sendData = true;

    public void setNMSEntity(Entity entity) {
        this.nmsEntity = entity;
        this.entityId = entity.ae();
        this.renderDistanceSq = Math.pow(Bukkit.getViewDistance() * 16, 2.0);
    }

    @Override
    public void spawn(Collection<AbstractPlayer> players) {
        for (AbstractPlayer player : players) {
            this.players.put(player, false);
        }
        this.updateRenderedPlayers();
    }

    @Override
    public void spawn(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        PacketPlayOutSpawnEntity spawnItem = new PacketPlayOutSpawnEntity(this.getNmsEntity());
        PacketPlayOutEntityMetadata data = new PacketPlayOutEntityMetadata(this.getNmsEntity().ae(), this.getNmsEntity().ai(), true);
        Schedulers.ensureAsync(() -> {
            ((CraftPlayer)player).getHandle().b.a((Packet)spawnItem);
            ((CraftPlayer)player).getHandle().b.a((Packet)data);
        });
    }

    @Override
    public void update(AbstractLocation location) {
        Entity nmsEntity = this.getNmsEntity();
        this.getNmsEntity().a(location.getX(), location.getY(), location.getZ(), location.getYaw(), 0.0f);
        Schedulers.ensureAsync(() -> {
            PacketPlayOutEntityMetadata packetData = null;
            if (this.sendData) {
                packetData = new PacketPlayOutEntityMetadata(nmsEntity.ae(), nmsEntity.ai(), true);
                this.sendData = false;
            }
            PacketPlayOutEntityTeleport packetTeleport = this.createTeleportPacket(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            for (AbstractPlayer player : this.players.keySet()) {
                if (packetData != null) {
                    ((CraftPlayer)player.getBukkitEntity()).getHandle().b.a((Packet)packetData);
                }
                ((CraftPlayer)player.getBukkitEntity()).getHandle().b.a((Packet)packetTeleport);
            }
        });
    }

    @Override
    public void destroy(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        this.players.put(target, false);
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{this.getNmsEntity().ae()});
        Schedulers.ensureAsync(() -> ((CraftPlayer)player).getHandle().b.a((Packet)destroyPacket));
    }

    @Override
    public void destroy() {
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{this.getNmsEntity().ae()});
        for (AbstractPlayer player : this.players.keySet()) {
            Schedulers.ensureAsync(() -> ((CraftPlayer)player.getBukkitEntity()).getHandle().b.a((Packet)destroyPacket));
        }
        this.players.clear();
    }

    @Override
    public void updateRenderedPlayers() {
        this.players.replaceAll((player, value) -> {
            double d2 = Math.pow(player.getLocation().getX() - this.nmsEntity.dc(), 2.0) + Math.pow(player.getLocation().getZ() - this.nmsEntity.di(), 2.0);
            if (value.booleanValue()) {
                if (d2 > this.renderDistanceSq) {
                    this.destroy((AbstractPlayer)player);
                    return false;
                }
            } else if (d2 <= this.renderDistanceSq) {
                this.spawn((AbstractPlayer)player);
                return true;
            }
            return value;
        });
    }

    protected PacketPlayOutEntityTeleport createTeleportPacket(double x, double y, double z, float yaw, float pitch) {
        PacketDataSerializer pos = new PacketDataSerializer(Unpooled.buffer());
        pos.d(this.entityId);
        pos.writeDouble(x);
        pos.writeDouble(y);
        pos.writeDouble(z);
        pos.writeByte((int)((byte)(yaw / 360.0f * 255.0f)));
        pos.writeByte(0);
        pos.writeBoolean(false);
        return new PacketPlayOutEntityTeleport(pos);
    }

    public Entity getNmsEntity() {
        return this.nmsEntity;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }
}

