/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_18_R2;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.damage.DamageMetadata;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileEntityHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.adventure.text.serializer.gson.GsonComponentSerializer;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.reflection.Reflector;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import io.lumine.mythic.core.volatilecode.v1_18_R2.VolatileCompoundTag;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftItem;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;

public class VolatileEntityHandlerImpl
implements VolatileEntityHandler {
    private static final String ENTITY_HEIGHT = "ba";
    private static final String ENTITY_DIMENSIONS = "aZ";
    private static final String ENTITY_EYE_HEIGHT = "ba";
    private static final String ATTRIBUTES = "b";
    private static final String BYPASS_ARMOR = "A";
    private static final String FOOD_EXHAUSTION = "D";
    private static final Reflector<net.minecraft.world.entity.Entity> refEntity = new Reflector<net.minecraft.world.entity.Entity>(net.minecraft.world.entity.Entity.class, "ba", "aZ", "ba");
    private static final Reflector<DamageSource> refDamageSource = new Reflector<DamageSource>(DamageSource.class, "A", "D");
    private static final Reflector<AttributeMapBase> refAttributeMap = new Reflector<AttributeMapBase>(AttributeMapBase.class, "b");

    public VolatileEntityHandlerImpl(VolatileCodeHandler handler) {
    }

    @Override
    public void setCustomName(AbstractEntity entity, String name) {
        net.minecraft.world.entity.Entity le = ((CraftEntity)entity.getBukkitEntity()).getHandle();
        le.a(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(Text.parse(name)))));
    }

    @Override
    public void registerAttribute(AbstractEntity entity, Attribute attribute) {
        EntityLiving livingEntity = ((CraftLivingEntity)entity.getBukkitEntity()).getHandle();
        AttributeMapBase attributeMap = livingEntity.eq();
        Map attributes = (Map)refAttributeMap.get(attributeMap, ATTRIBUTES);
        AttributeBase nmsAttribute = CraftAttributeMap.toMinecraft((Attribute)attribute);
        AttributeModifiable attributeInstance = new AttributeModifiable(nmsAttribute, AttributeModifiable::a);
        attributes.put(nmsAttribute, attributeInstance);
    }

    @Override
    public void stopUsingItem(AbstractEntity entity) {
        EntityLiving living = ((CraftLivingEntity)entity.getBukkitEntity()).getHandle();
        living.eR();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDamage(DamageMetadata data, AbstractEntity aTarget) {
        SkillCaster caster = data.getDamager();
        double damage = data.getAmount();
        DamageSource reason = this.getDamageSource(data);
        if (aTarget == null) {
            return;
        }
        if (!aTarget.isDamageable()) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Damage cancelled: target is not damageable", new Object[0]);
            return;
        }
        caster.setUsingDamageSkill(true);
        caster.getEntity().setMetadata("doing-skill-damage", true);
        aTarget.setMetadata("skill-damage", data);
        if (caster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)caster;
            am.setLastDamageSkillAmount(damage);
        }
        EntityLiving target = ((CraftLivingEntity)aTarget.getBukkitEntity()).getHandle();
        AttributeModifier mod = new AttributeModifier(UUID.randomUUID(), "mythic$kbresist", 1.0, AttributeModifier.Operation.ADD_NUMBER);
        try {
            if (data.getPreventsKnockback().booleanValue()) {
                ((CraftLivingEntity)aTarget.getBukkitEntity()).getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE).addModifier(mod);
            }
            target.a(reason, (float)damage);
        }
        catch (Exception ex) {
            if (ConfigExecutor.debugLevel > 0) {
                ex.printStackTrace();
            }
        }
        finally {
            if (data.getPreventsImmunity().booleanValue()) {
                aTarget.setNoDamageTicks(0);
            }
            ((CraftLivingEntity)aTarget.getBukkitEntity()).getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE).removeModifier(mod);
            caster.getEntity().removeMetadata("doing-skill-damage");
            caster.setUsingDamageSkill(false);
            aTarget.removeMetadata("skill-damage");
        }
    }

    private DamageSource getDamageSource(DamageMetadata data) {
        DamageSource src = DamageSource.n;
        net.minecraft.world.entity.Entity source = ((CraftEntity)data.getDamager().getEntity().getBukkitEntity()).getHandle();
        switch (data.getDamageCause()) {
            case CONTACT: {
                src = DamageSource.j;
                break;
            }
            case ENTITY_ATTACK: {
                EntityLiving living;
                if (source instanceof EntityHuman) {
                    EntityHuman player = (EntityHuman)source;
                    src = DamageSource.a((EntityHuman)player);
                    break;
                }
                src = DamageSource.c(source instanceof EntityLiving ? (living = (EntityLiving)source) : null);
                break;
            }
            case ENTITY_SWEEP_ATTACK: {
                if (src == DamageSource.n) break;
                src = src.sweep();
                break;
            }
            case PROJECTILE: {
                Projectile projectile;
                CraftEntity craftEntity = source.getBukkitEntity();
                src = DamageSource.b((net.minecraft.world.entity.Entity)source, craftEntity instanceof Projectile && (projectile = (Projectile)craftEntity).getShooter() instanceof Entity ? ((CraftEntity)((Projectile)source.getBukkitEntity()).getShooter()).getHandle() : null);
                break;
            }
            case SUFFOCATION: {
                src = DamageSource.f;
                break;
            }
            case FALL: {
                src = DamageSource.k;
                break;
            }
            case FIRE: {
                src = DamageSource.a;
                break;
            }
            case FIRE_TICK: {
                src = DamageSource.c;
                break;
            }
            case MELTING: {
                src = CraftEventFactory.MELTING;
                break;
            }
            case LAVA: {
                src = DamageSource.d;
                break;
            }
            case DROWNING: {
                src = DamageSource.h;
                break;
            }
            case BLOCK_EXPLOSION: {
                TNTPrimed tntPrimed;
                src = DamageSource.d(source instanceof TNTPrimed && (tntPrimed = (TNTPrimed)source).getSource() instanceof EntityLiving ? (EntityLiving)tntPrimed.getSource() : null);
                break;
            }
            case ENTITY_EXPLOSION: {
                EntityLiving living;
                src = DamageSource.d(source instanceof EntityLiving ? (living = (EntityLiving)source) : null);
                break;
            }
            case VOID: {
                src = DamageSource.m;
                break;
            }
            case LIGHTNING: {
                src = DamageSource.b;
                break;
            }
            case STARVATION: {
                src = DamageSource.i;
                break;
            }
            case POISON: {
                src = CraftEventFactory.POISON;
                break;
            }
            case MAGIC: {
                src = DamageSource.o;
                break;
            }
            case WITHER: {
                src = DamageSource.p;
                break;
            }
            case FALLING_BLOCK: {
                src = DamageSource.r;
                break;
            }
            case THORNS: {
                src = DamageSource.a((net.minecraft.world.entity.Entity)source);
                break;
            }
            case DRAGON_BREATH: {
                src = DamageSource.s;
                break;
            }
            case FLY_INTO_WALL: {
                src = DamageSource.l;
                break;
            }
            case HOT_FLOOR: {
                src = DamageSource.e;
                break;
            }
            case CRAMMING: {
                src = DamageSource.g;
                break;
            }
            case DRYOUT: {
                src = DamageSource.t;
                break;
            }
            case FREEZE: {
                src = DamageSource.v;
            }
        }
        if (data.getIgnoresArmor().booleanValue()) {
            refDamageSource.set(src, BYPASS_ARMOR, true);
            refDamageSource.set(src, FOOD_EXHAUSTION, Float.valueOf(0.0f));
        }
        return src;
    }

    @Override
    public float getEntityAbsorptionHearts(AbstractEntity entity) {
        if (!entity.isLiving()) {
            return 0.0f;
        }
        EntityLiving el = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
        return el.eJ();
    }

    @Override
    public void setEntityAbsorptionHearts(AbstractEntity entity, float value) {
        if (!entity.isLiving()) {
            return;
        }
        EntityLiving el = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
        el.t(value);
    }

    @Override
    public void setLocation(AbstractEntity entity, AbstractLocation location) {
    }

    @Override
    public void setLocation(AbstractEntity entity, double x, double y, double z, float yaw, float pitch) {
    }

    @Override
    public void setLocation(AbstractEntity entity, double x, double y, double z, float yaw, float pitch, boolean noRotation, boolean noGravity) {
        net.minecraft.world.entity.Entity e = ((CraftEntity)entity.getBukkitEntity()).getHandle();
        e.a(x, y, z, yaw, pitch);
        if (entity.isPlayer()) {
            this.playerConnectionTeleport(entity, x, y, z, yaw, pitch, noRotation, noGravity);
        }
        if (e.s instanceof WorldServer) {
            // empty if block
        }
    }

    @Override
    public void setPlayerRotation(AbstractPlayer entity, float yaw, float pitch) {
        EntityPlayer me = ((CraftPlayer)entity.getBukkitEntity()).getHandle();
        HashSet<PacketPlayOutPosition.EnumPlayerTeleportFlags> set = new HashSet<PacketPlayOutPosition.EnumPlayerTeleportFlags>();
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.a);
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.b);
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.c);
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.e);
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.d);
        me.b.a((Packet)new PacketPlayOutPosition(0.0, 0.0, 0.0, yaw, pitch, set, 0, false));
    }

    private void playerConnectionTeleport(AbstractEntity entity, double x, double y, double z, float yaw, float pitch, boolean noRotation, boolean noGravity) {
        EntityPlayer me = ((CraftPlayer)entity.getBukkitEntity()).getHandle();
        HashSet<PacketPlayOutPosition.EnumPlayerTeleportFlags> set = new HashSet<PacketPlayOutPosition.EnumPlayerTeleportFlags>();
        boolean dismountVehicle = false;
        if (noRotation) {
            pitch = 0.0f;
            yaw = 0.0f;
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.e);
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.d);
        }
        if (noGravity) {
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.b);
            y = 0.0;
        }
        me.b.a((Packet)new PacketPlayOutPosition(x, y, z, yaw, pitch, set, 0, dismountVehicle));
    }

    @Override
    public boolean isEntityInMotion(AbstractEntity entity, boolean exact) {
        if (entity.isLiving()) {
            EntityLiving e = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
            Vec3D position = e.cV();
            if (exact) {
                if (e.t != position.a() || e.u != position.b() || e.v != position.c()) {
                    return true;
                }
            } else {
                int x = Numbers.floor(e.t);
                int y = Numbers.floor(e.u);
                int z = Numbers.floor(e.v);
                int pX = Numbers.floor(position.a());
                int pY = Numbers.floor(position.b());
                int pZ = Numbers.floor(position.c());
                if (x != pX || y != pY || z != pZ) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public AbstractVector getEntityMotion(AbstractEntity entity) {
        if (entity.isLiving()) {
            EntityLiving e = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
            Vec3D position = e.cV();
            double x = position.a() - e.t;
            double y = position.b() - e.u;
            double z = position.c() - e.v;
            return new AbstractVector(x, y, z);
        }
        return new AbstractVector(0, 0, 0);
    }

    @Override
    public void setHitBox(AbstractEntity target, double x, double y) {
        Entity entity = BukkitAdapter.adapt(target);
        net.minecraft.world.entity.Entity ent = ((CraftEntity)entity).getHandle();
        AxisAlignedBB bb = new AxisAlignedBB(ent.dc() - x / 2.0, ent.de(), ent.di() - x / 2.0, ent.dc() + x / 2.0, ent.de() + y, ent.di() + x / 2.0);
        ent.a(bb);
        refEntity.set(ent, "ba", Float.valueOf((float)y));
        refEntity.set(ent, ENTITY_DIMENSIONS, new EntitySize((float)x, (float)y, true));
        refEntity.set(ent, "ba", Float.valueOf((float)(y * 0.8)));
    }

    @Override
    public void setItemPosition(AbstractEntity target, AbstractLocation ol) {
        Entity entity = BukkitAdapter.adapt(target);
        if (entity instanceof Item) {
            Item item = (Item)entity;
            EntityItem ei = (EntityItem)((CraftItem)item).getHandle();
            ei.g(ol.getX(), ol.getY(), ol.getZ());
        }
    }

    @Override
    public void sendEntityTeleportPacket(AbstractEntity target) {
        Entity entity = BukkitAdapter.adapt(target);
        net.minecraft.world.entity.Entity me = ((CraftEntity)entity).getHandle();
        PacketPlayOutEntityTeleport tp = new PacketPlayOutEntityTeleport(me);
        entity.getLocation().getWorld().getNearbyEntities(entity.getLocation(), 32.0, 32.0, 32.0).forEach(e -> {
            if (e instanceof Player) {
                ((CraftPlayer)e).getHandle().b.a((Packet)tp);
            }
        });
    }

    @Override
    public void setEntityRotation(AbstractEntity target, float pitch, float yaw) {
        Entity entity = BukkitAdapter.adapt(target);
        net.minecraft.world.entity.Entity me = ((CraftEntity)entity).getHandle();
        me.o(yaw);
        me.p(pitch);
    }

    @Override
    public void setArmorStandNoGravity(AbstractEntity target) {
        Entity entity = BukkitAdapter.adapt(target);
        if (entity.getType() == EntityType.ARMOR_STAND) {
            EntityArmorStand as = (EntityArmorStand)((CraftEntity)entity).getHandle();
            as.e(true);
        }
    }

    @Override
    public void sendGameStateChange(AbstractPlayer target, int state, int skybox) {
        Player player = BukkitAdapter.adapt(target);
        PacketPlayOutGameStateChange packet = new PacketPlayOutGameStateChange(new PacketPlayOutGameStateChange.a(state), (float)skybox);
        ((CraftPlayer)player).getHandle().b.a((Packet)packet);
    }

    @Override
    public void forcePlayCredits(AbstractPlayer target, float f) {
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        me.b.a((Packet)new PacketPlayOutGameStateChange(new PacketPlayOutGameStateChange.a(4), f));
    }

    @Override
    public void forceCloseWindow(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        me.b.a((Packet)new PacketPlayOutCloseWindow(0));
    }

    @Override
    public void setPlayerWorldBorder(AbstractPlayer target, AbstractLocation center, int radius) {
        WorldBorder border;
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        if (radius == -1) {
            border = ep.x().p_();
        } else {
            border = new WorldBorder();
            border.world = ep.x().p_().world;
            border.c(center.getX(), center.getZ());
            border.a((double)radius);
            border.c(1);
        }
        ep.b.a((Packet)new ClientboundSetBorderCenterPacket(border));
        ep.b.a((Packet)new ClientboundSetBorderWarningDistancePacket(border));
        ep.b.a((Packet)new ClientboundSetBorderSizePacket(border));
    }

    @Override
    public void sendPlayerFakeInventoryItem(AbstractPlayer target, ItemStack stack, int slot) {
        if (slot < 9) {
            slot += 36;
        }
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        net.minecraft.world.item.ItemStack item = CraftItemStack.asNMSCopy((ItemStack)stack);
        PacketPlayOutSetSlot packet = new PacketPlayOutSetSlot(0, 0, slot, item);
        entityPlayer.b.a((Packet)packet);
    }

    public void hideEntityModel(AbstractEntity target) {
        Entity entity = BukkitAdapter.adapt(target);
        net.minecraft.world.entity.Entity me = ((CraftEntity)entity).getHandle();
        DataWatcher w = me.ai();
        w.b(new DataWatcherObject(0, DataWatcherRegistry.a), (Object)32);
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata(me.ae(), w, true);
    }

    @Override
    public void playTotemEffect(AbstractPlayer target, int model) {
        this.sendPlayerFakeInventoryItem(target, ItemFactory.of(Material.TOTEM_OF_UNDYING).model(model).build(), 45);
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        PacketPlayOutEntityStatus packet = new PacketPlayOutEntityStatus((net.minecraft.world.entity.Entity)me, 35);
        me.b.a((Packet)packet);
        player.stopSound(Sound.ITEM_TOTEM_USE, SoundCategory.MASTER);
        Schedulers.async().runLater(() -> this.sendPlayerFakeInventoryItem(target, player.getInventory().getItemInOffHand(), 45), 1L);
    }

    @Override
    public void setEntitySpawnReason(AbstractEntity target, CreatureSpawnEvent.SpawnReason reason) {
        Entity entity = BukkitAdapter.adapt(target);
        World world = BukkitAdapter.adapt(target.getWorld());
        net.minecraft.world.entity.Entity entityHandle = ((CraftEntity)entity).getHandle();
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        worldHandle.addFreshEntity(entityHandle, reason);
    }

    @Override
    public void playFreezeEffect(AbstractPlayer target, int ticks) {
        Player player = (Player)target.getBukkitEntity();
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        me.j(ticks);
        me.b.a((Packet)new PacketPlayOutEntityMetadata(me.ae(), me.ai(), true));
    }

    @Override
    public void playEntityAnimation(AbstractEntity target, byte effect, Collection<AbstractPlayer> audience) {
        net.minecraft.world.entity.Entity e = ((CraftEntity)target.getBukkitEntity()).getHandle();
        PacketPlayOutAnimation packet = new PacketPlayOutAnimation(e, (int)effect);
        for (AbstractPlayer entity : audience) {
            if (!entity.isPlayer()) continue;
            Player player = (Player)entity.getBukkitEntity();
            EntityPlayer me = ((CraftPlayer)player).getHandle();
            me.b.a((Packet)packet);
        }
    }

    @Override
    public void spawnFakeLightning(AbstractLocation target, double radius) {
        Location location = BukkitAdapter.adapt(target);
        World world = location.getWorld();
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        EntityLightning entitylightning = (EntityLightning)EntityTypes.U.a((net.minecraft.world.level.World)worldHandle);
        entitylightning.b(Vec3D.a((BaseBlockPosition)new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ())));
        entitylightning.a(true);
        PacketPlayOutSpawnEntity spawnItem = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)entitylightning);
        double distanceSquared = radius * radius;
        Schedulers.async().run(() -> {
            for (Player player : location.getWorld().getPlayers()) {
                if (!(location.distanceSquared(player.getLocation()) <= distanceSquared)) continue;
                ((CraftPlayer)player).getHandle().b.a((Packet)spawnItem);
                player.playSound(location, "entity.lightning_bolt.impact", 1.0f, 1.0f);
                player.playSound(location, "entity.lightning_bolt.thunder", 10000.0f, 63.0f);
            }
        });
    }

    @Override
    public AbstractEntity addNBTData(AbstractEntity entity, String key, Tag value) {
        CompoundTag compound = this.getNBTData(entity).createBuilder().put(key, value).build();
        this.setNBTData(entity, compound);
        return entity;
    }

    @Override
    public CompoundTag getNBTData(AbstractEntity entity) {
        Entity bukkitEntity = entity.getBukkitEntity();
        NBTTagCompound compound = new NBTTagCompound();
        return VolatileCompoundTag.fromNMSTag(compound);
    }

    @Override
    public AbstractEntity setNBTData(AbstractEntity entity, CompoundTag compoundTag) {
        Entity bukkitEntity = entity.getBukkitEntity();
        return entity;
    }

    @Override
    public void sendActionBarMessageToPlayer(AbstractPlayer target, String message) {
        Player player = BukkitAdapter.adapt(target);
    }
}

