/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_16_R3.virtual;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.virtual.PacketItem;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.volatilecode.v1_16_R3.virtual.VirtualEntity;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityItem;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutCollect;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class VirtualItem
extends VirtualEntity
implements PacketItem {
    private EntityItem itemEntity;

    public VirtualItem(ItemStack itemStack, AbstractLocation location) {
        this.itemEntity = this.createItemEntity(itemStack, location);
        this.itemEntity.setNoGravity(true);
        this.setNMSEntity((Entity)this.itemEntity);
    }

    private EntityItem createItemEntity(ItemStack itemStack, AbstractLocation location) {
        WorldServer nmsWorld = ((CraftWorld)BukkitAdapter.adapt(location.getWorld())).getHandle();
        return new EntityItem((World)nmsWorld, location.getX(), location.getY(), location.getZ(), CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    public void collect(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        int playerId = ((CraftPlayer)player).getHandle().getId();
        PacketPlayOutCollect spawnItem = new PacketPlayOutCollect(this.itemEntity.getId(), playerId, 1);
        Schedulers.async().run(() -> ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)spawnItem));
    }

    @Override
    public void update(ItemStack itemStack, AbstractLocation location) {
        this.itemEntity.setItemStack(CraftItemStack.asNMSCopy((ItemStack)itemStack));
        this.itemEntity.setPositionRotation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        PacketPlayOutEntityMetadata packetData = new PacketPlayOutEntityMetadata(this.itemEntity.getId(), this.itemEntity.getDataWatcher(), true);
        PacketPlayOutEntityTeleport packetTeleport = new PacketPlayOutEntityTeleport((Entity)this.itemEntity);
        Schedulers.async().run(() -> {
            for (AbstractPlayer player : this.players.keySet()) {
                ((CraftPlayer)player.getBukkitEntity()).getHandle().playerConnection.sendPacket((Packet)packetData);
                ((CraftPlayer)player.getBukkitEntity()).getHandle().playerConnection.sendPacket((Packet)packetTeleport);
            }
        });
    }
}

