/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_16_R3.virtual;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.volatilecode.virtual.PacketFallingBlock;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.volatilecode.v1_16_R3.virtual.VirtualEntity;
import net.minecraft.server.v1_16_R3.BlockBell;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityFallingBlock;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class VirtualFallingBlock
extends VirtualEntity
implements PacketFallingBlock {
    private final BlockData blockData;
    private EntityFallingBlock blockEntity;

    public VirtualFallingBlock(BlockData blockData, AbstractLocation location) {
        this.blockData = blockData;
        this.blockEntity = this.createBlockEntity(blockData, location);
        this.blockEntity.setNoGravity(true);
        this.setNMSEntity((Entity)this.blockEntity);
    }

    private EntityFallingBlock createBlockEntity(BlockData blockData, AbstractLocation location) {
        WorldServer nmsWorld = ((CraftWorld)BukkitAdapter.adapt(location.getWorld())).getHandle();
        IBlockData blockState = ((CraftBlockData)blockData).getState();
        return new EntityFallingBlock((World)nmsWorld, location.getX() + 0.5, location.getY() + 0.5, location.getZ() + 0.5, blockState);
    }

    @Override
    public void spawn(AbstractPlayer target) {
        IBlockData blockState = ((CraftBlockData)this.blockData).getState();
        Player player = BukkitAdapter.adapt(target);
        this.getNmsEntity().setPositionRotation(this.getNmsEntity().locX(), this.getNmsEntity().locY(), this.getNmsEntity().locZ(), 0.0f, 0.0f);
        PacketPlayOutSpawnEntity spawnItem = new PacketPlayOutSpawnEntity((Entity)this.blockEntity, BlockBell.getCombinedId((IBlockData)blockState));
        PacketPlayOutEntityMetadata data = new PacketPlayOutEntityMetadata(this.blockEntity.getId(), this.getNmsEntity().getDataWatcher(), true);
        Schedulers.async().run(() -> {
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)spawnItem);
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)data);
        });
    }

    @Override
    public void update(AbstractLocation location) {
        Entity nmsEntity = this.getNmsEntity();
        double currentX = nmsEntity.locX();
        double currentY = nmsEntity.locY();
        double currentZ = nmsEntity.locZ();
        double newX = location.getX() + 0.5;
        double newY = location.getY() + 0.5;
        double newZ = location.getZ() + 0.5;
        this.getNmsEntity().setPositionRotation(newX, newY, newZ, 0.0f, 0.0f);
        double distance = Math.pow(newX - currentX, 2.0) + Math.pow(newY - currentY, 2.0) + Math.pow(newZ - currentZ, 2.0);
        if (distance < 64.0) {
            AbstractVector currentVector = new AbstractVector(currentX, currentY, currentZ);
            AbstractVector newVector = new AbstractVector(newX, newY, newZ);
            AbstractVector velocity = newVector.subtract(currentVector).multiply(1);
            PacketPlayOutEntityVelocity packetV = new PacketPlayOutEntityVelocity(nmsEntity.getId(), new Vec3D(velocity.getX(), velocity.getY(), velocity.getZ()));
            Schedulers.async().run(() -> {
                for (AbstractPlayer player : this.players.keySet()) {
                    ((CraftPlayer)player.getBukkitEntity()).getHandle().playerConnection.sendPacket((Packet)packetV);
                }
            });
        } else {
            this.blockEntity.teleportAndSync(location.getX(), location.getY(), location.getZ());
            PacketPlayOutEntityMetadata packetData = new PacketPlayOutEntityMetadata(nmsEntity.getId(), this.blockEntity.getDataWatcher(), true);
            PacketPlayOutEntityTeleport packetTeleport = new PacketPlayOutEntityTeleport(nmsEntity);
            Schedulers.async().run(() -> {
                for (AbstractPlayer player : this.players.keySet()) {
                    ((CraftPlayer)player.getBukkitEntity()).getHandle().playerConnection.sendPacket((Packet)packetData);
                    ((CraftPlayer)player.getBukkitEntity()).getHandle().playerConnection.sendPacket((Packet)packetTeleport);
                }
            });
        }
    }

    @Override
    public void destroy(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        this.players.remove(player);
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{this.blockEntity.getId()});
        Schedulers.async().run(() -> ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)destroyPacket));
    }

    @Override
    public void destroy() {
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{this.blockEntity.getId()});
        for (AbstractPlayer player : this.players.keySet()) {
            Schedulers.async().run(() -> ((CraftPlayer)player.getBukkitEntity()).getHandle().playerConnection.sendPacket((Packet)destroyPacket));
        }
        this.players.clear();
    }
}

