/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_16_R3.virtual;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Map;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketDataSerializer;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class VirtualEntity
implements PacketEntity {
    private Entity nmsEntity;
    private int entityId;
    private double renderDistanceSq = 25000.0;
    protected Map<AbstractPlayer, Boolean> players = Maps.newConcurrentMap();
    protected boolean sendData = true;

    public void setNMSEntity(Entity entity) {
        this.nmsEntity = entity;
        this.entityId = entity.getId();
        this.renderDistanceSq = Math.pow(Bukkit.getViewDistance() * 16, 2.0);
    }

    @Override
    public void spawn(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        this.getNmsEntity().setPositionRotation(this.getNmsEntity().locX(), this.getNmsEntity().locY(), this.getNmsEntity().locZ(), 0.0f, 0.0f);
        PacketPlayOutSpawnEntity spawnItem = new PacketPlayOutSpawnEntity(this.getNmsEntity());
        PacketPlayOutEntityMetadata data = new PacketPlayOutEntityMetadata(this.getNmsEntity().getId(), this.nmsEntity.getDataWatcher(), true);
        Schedulers.async().run(() -> {
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)spawnItem);
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)data);
        });
    }

    @Override
    public void spawn(Collection<AbstractPlayer> players) {
        for (AbstractPlayer player : players) {
            this.players.put(player, false);
        }
        this.updateRenderedPlayers();
    }

    @Override
    public void update(AbstractLocation location) {
        Entity nmsEntity = this.getNmsEntity();
        nmsEntity.setPositionRotation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        PacketPlayOutEntityMetadata packetData = new PacketPlayOutEntityMetadata(nmsEntity.getId(), nmsEntity.getDataWatcher(), true);
        PacketPlayOutEntityTeleport packetTeleport = new PacketPlayOutEntityTeleport(nmsEntity);
        Schedulers.async().run(() -> {
            for (AbstractPlayer player : this.players.keySet()) {
                ((CraftPlayer)player.getBukkitEntity()).getHandle().playerConnection.sendPacket((Packet)packetData);
                ((CraftPlayer)player.getBukkitEntity()).getHandle().playerConnection.sendPacket((Packet)packetTeleport);
            }
        });
    }

    @Override
    public void destroy(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        this.players.remove(player);
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{this.getNmsEntity().getId()});
        Schedulers.async().run(() -> ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)destroyPacket));
    }

    @Override
    public void destroy() {
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{this.getNmsEntity().getId()});
        for (AbstractPlayer player : this.players.keySet()) {
            Schedulers.async().run(() -> ((CraftPlayer)player.getBukkitEntity()).getHandle().playerConnection.sendPacket((Packet)destroyPacket));
        }
        this.players.clear();
    }

    @Override
    public void updateRenderedPlayers() {
        this.players.replaceAll((player, value) -> {
            double d2 = Math.pow(player.getLocation().getX() - this.nmsEntity.locX(), 2.0) + Math.pow(player.getLocation().getZ() - this.nmsEntity.locZ(), 2.0);
            if (value.booleanValue()) {
                if (d2 > this.renderDistanceSq) {
                    this.destroy((AbstractPlayer)player);
                    return false;
                }
            } else if (d2 <= this.renderDistanceSq) {
                this.spawn((AbstractPlayer)player);
                return true;
            }
            return value;
        });
    }

    protected PacketPlayOutEntityTeleport createTeleportPacket(double x, double y, double z, float yaw, float pitch) {
        PacketDataSerializer pos = new PacketDataSerializer(Unpooled.buffer());
        pos.writeInt(this.entityId);
        pos.writeDouble(x);
        pos.writeDouble(y);
        pos.writeDouble(z);
        pos.writeByte((int)((byte)(yaw / 360.0f * 255.0f)));
        pos.writeByte(0);
        pos.writeBoolean(false);
        PacketPlayOutEntityTeleport packet = new PacketPlayOutEntityTeleport(this.nmsEntity);
        try {
            packet.a(pos);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return packet;
    }

    public Entity getNmsEntity() {
        return this.nmsEntity;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }
}

