/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_16_R3.virtual;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.virtual.PacketArmorStand;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.volatilecode.v1_16_R3.virtual.VirtualEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityArmorStand;
import net.minecraft.server.v1_16_R3.EnumItemSlot;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R3.Vector3f;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class VirtualArmorStand
extends VirtualEntity
implements PacketArmorStand {
    private EntityArmorStand armorStandEntity;
    private PacketArmorStand.PacketArmorStandOptions options;

    public VirtualArmorStand(AbstractLocation location, PacketArmorStand.PacketArmorStandOptions options) {
        this.armorStandEntity = this.createArmorStand(location, options);
        this.setNMSEntity((Entity)this.armorStandEntity);
        this.options = options;
    }

    private EntityArmorStand createArmorStand(AbstractLocation location, PacketArmorStand.PacketArmorStandOptions options) {
        WorldServer nmsWorld = ((CraftWorld)BukkitAdapter.adapt(location.getWorld())).getHandle();
        EntityArmorStand armorStandEntity = new EntityArmorStand((World)nmsWorld, location.getX(), location.getY(), location.getZ());
        armorStandEntity.setPositionRotation(location.getX(), location.getY(), location.getZ(), location.getPitch(), location.getYaw());
        armorStandEntity.setInvisible(true);
        armorStandEntity.setNoGravity(true);
        if (options.getHeadItem() != null) {
            armorStandEntity.setSlot(EnumItemSlot.HEAD, CraftItemStack.asNMSCopy((ItemStack)options.getHeadItem()));
        }
        if (options.isSmall()) {
            armorStandEntity.setSmall(true);
        }
        if (options.isUpsideDown()) {
            armorStandEntity.setCustomName(CraftChatMessage.fromStringOrNull((String)"Dinnerbone"));
            armorStandEntity.setCustomNameVisible(false);
        }
        return armorStandEntity;
    }

    @Override
    public void spawn(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        PacketPlayOutSpawnEntity packetSpawn = new PacketPlayOutSpawnEntity(this.getNmsEntity());
        ArrayList equipmentList = Lists.newArrayList();
        equipmentList.add(new Pair((Object)EnumItemSlot.HEAD, (Object)CraftItemStack.asNMSCopy((ItemStack)this.options.getHeadItem())));
        PacketPlayOutEntityEquipment packetEquipment = new PacketPlayOutEntityEquipment(this.armorStandEntity.getId(), (List)equipmentList);
        Schedulers.async().run(() -> {
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packetSpawn);
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packetEquipment);
        });
    }

    @Override
    public void setHeadPose(EulerAngle rot) {
        Vector3f rotation = new Vector3f((float)Math.toDegrees(rot.getX()), (float)Math.toDegrees(rot.getY()), (float)Math.toDegrees(rot.getZ()));
        this.armorStandEntity.setHeadPose(rotation);
    }
}

