/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_16_R3;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileWorldHandler;
import io.lumine.mythic.api.volatilecode.virtual.PacketArmorStand;
import io.lumine.mythic.api.volatilecode.virtual.PacketFallingBlock;
import io.lumine.mythic.api.volatilecode.virtual.PacketItem;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.reflection.Reflector;
import io.lumine.mythic.core.volatilecode.v1_16_R3.virtual.VirtualArmorStand;
import io.lumine.mythic.core.volatilecode.v1_16_R3.virtual.VirtualFallingBlock;
import io.lumine.mythic.core.volatilecode.v1_16_R3.virtual.VirtualItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.Chunk;
import net.minecraft.server.v1_16_R3.ChunkProviderServer;
import net.minecraft.server.v1_16_R3.DifficultyDamageScaler;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityArmorStand;
import net.minecraft.server.v1_16_R3.EntityFallingBlock;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.MathHelper;
import net.minecraft.server.v1_16_R3.MovingObjectPosition;
import net.minecraft.server.v1_16_R3.MovingObjectPositionBlock;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R3.RayTrace;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_16_R3.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftRayTraceResult;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class VolatileWorldHandler_v1_16_R3
implements VolatileWorldHandler {
    private static final Reflector<ChunkProviderServer> refChunkProviderServer = new Reflector<ChunkProviderServer>(ChunkProviderServer.class, "serverThread");
    private static final Reflector<World> refWorldThread = new Reflector<World>(World.class, "serverThread");

    public VolatileWorldHandler_v1_16_R3(VolatileCodeHandler handler) {
    }

    @Override
    public void playSoundAtLocation(AbstractLocation location, String sound, float volume, float pitch, double radius) {
        Location l = BukkitAdapter.adapt(location);
        l.getWorld().playSound(l, sound, volume, pitch);
    }

    @Override
    public boolean isChunkLoaded(AbstractWorld world, int x, int z) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        return null != nmsWorld.getChunkAt(x, z);
    }

    @Override
    public int getEntitiesInChunk(AbstractWorld world, int x, int z) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        Chunk chunk = nmsWorld.getChunkAt(x, z);
        if (chunk == null) {
            return 0;
        }
        int amount = 0;
        for (List slice : chunk.getEntitySlices()) {
            amount += slice.size();
        }
        return amount;
    }

    @Override
    public void doBlockTossEffect(AbstractLocation target, Material material, AbstractVector velocity, int duration, boolean hideSourceBlock) {
        Location location = BukkitAdapter.adapt(target);
        BlockPosition blockPosition = new BlockPosition(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        CraftWorld bukkitWorld = (CraftWorld)location.getWorld();
        WorldServer nmsWorld = bukkitWorld.getHandle();
        IBlockData blockState = material == null ? nmsWorld.getType(blockPosition) : ((CraftBlockData)Bukkit.createBlockData((Material)material)).getState();
        EntityFallingBlock block = new EntityFallingBlock((World)nmsWorld, (double)target.getBlockX() + 0.5, (double)(target.getBlockY() + 1), (double)target.getBlockZ() + 0.5, blockState);
        PacketPlayOutSpawnEntity packet = new PacketPlayOutSpawnEntity((Entity)block, block.getEntityType(), net.minecraft.server.v1_16_R3.Block.getCombinedId((IBlockData)blockState), blockPosition);
        PacketPlayOutEntityVelocity packetV = new PacketPlayOutEntityVelocity(block.getId(), new Vec3D(velocity.getX(), velocity.getY(), velocity.getZ()));
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (hideSourceBlock) {
                p.sendBlockChange(location, Material.AIR, (byte)0);
            }
            ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)packet);
            ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)packetV);
            Schedulers.async().runLater(() -> {
                PacketPlayOutEntityDestroy packet2 = new PacketPlayOutEntityDestroy(new int[]{block.getId()});
                ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)packet2);
                if (hideSourceBlock) {
                    p.sendBlockChange(location, location.getBlock().getType(), (byte)0);
                }
            }, duration);
        }
    }

    @Override
    public float getDifficultyScale(AbstractLocation location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        DifficultyDamageScaler scaler = ((CraftWorld)location.getWorld()).getHandle().getDamageScaler(pos);
        return scaler.b();
    }

    @Override
    public Collection<AbstractEntity> getEntitiesNearLocation(AbstractLocation location, double radius, Predicate<AbstractEntity> predicate) {
        ArrayList<AbstractEntity> entities = new ArrayList<AbstractEntity>();
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(location.getWorld());
        WorldServer nmsWorld = bukkitWorld.getHandle();
        int smallX = MathHelper.floor((double)((location.getX() - radius) / 16.0));
        int bigX = MathHelper.floor((double)((location.getX() + radius) / 16.0));
        int smallZ = MathHelper.floor((double)((location.getZ() - radius) / 16.0));
        int bigZ = MathHelper.floor((double)((location.getZ() + radius) / 16.0));
        for (org.bukkit.entity.Entity e : bukkitWorld.getLivingEntities()) {
            AbstractEntity entity = BukkitAdapter.adapt(e);
            if (predicate != null && !predicate.test(entity)) continue;
            entities.add(entity);
        }
        return entities;
    }

    @Override
    public RayTraceResult rayTraceBlock(AbstractLocation start, AbstractLocation end, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        org.bukkit.World world = BukkitAdapter.adapt(start).getWorld();
        if (world == null) {
            return null;
        }
        WorldServer level = ((CraftWorld)world).getHandle();
        Vec3D startPos = new Vec3D(start.getX(), start.getY(), start.getZ());
        Vec3D endPos = new Vec3D(end.getX(), end.getY(), end.getZ());
        MovingObjectPositionBlock nmsHitResult = level.rayTrace(new RayTrace(startPos, endPos, ignorePassableBlocks ? RayTrace.BlockCollisionOption.COLLIDER : RayTrace.BlockCollisionOption.OUTLINE, CraftFluidCollisionMode.toNMS((FluidCollisionMode)fluidCollisionMode), null));
        return CraftRayTraceResult.fromNMS((org.bukkit.World)world, (MovingObjectPosition)nmsHitResult);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<org.bukkit.entity.Entity> filter) {
        Validate.notNull((Object)start, (String)"Start location is null!");
        start.checkFinite();
        Validate.notNull((Object)direction, (String)"Direction is null!");
        direction.checkFinite();
        Validate.isTrue((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude is 0!");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of((Vector)startPos, (Vector)startPos).expandDirectional(dir).expand(raySize);
        Collection entities = start.getWorld().getNearbyEntities(aabb, filter);
        org.bukkit.entity.Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (org.bukkit.entity.Entity entity : entities) {
            double distanceSq;
            BoundingBox boundingBox = entity.getBoundingBox().expand(raySize);
            RayTraceResult hitResult = boundingBox.rayTrace(startPos, direction, maxDistance);
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    @Override
    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, double raySize, Predicate<org.bukkit.entity.Entity> entityFilter, Predicate<Material> blockFilter) {
        double distance;
        if (direction.lengthSquared() < 1.0E-5 || maxDistance <= 1.0E-5) {
            return null;
        }
        RayTraceResult blockRayTrace = null;
        RayTraceResult entityRayTrace = start.getWorld().rayTraceEntities(start, direction, maxDistance, raySize, entityFilter);
        if (entityRayTrace != null && entityRayTrace.getHitEntity() != null) {
            distance = start.distance(entityRayTrace.getHitEntity().getLocation());
            if (distance == 0.0) {
                distance = maxDistance;
            }
        } else {
            distance = maxDistance;
        }
        BlockIterator bIterator = new BlockIterator(start.getWorld(), start.toVector(), direction, 0.0, (int)Math.ceil(distance));
        Block block = null;
        while (bIterator.hasNext()) {
            RayTraceResult res;
            block = bIterator.next();
            if (block.isEmpty() || blockFilter.test(block.getType()) || (res = block.rayTrace(start, direction, distance, FluidCollisionMode.ALWAYS)) == null) continue;
            blockRayTrace = res;
            break;
        }
        if (entityRayTrace != null && entityRayTrace.getHitEntity() != null) {
            if (blockRayTrace != null) {
                return blockRayTrace;
            }
            return entityRayTrace;
        }
        if (blockRayTrace != null) {
            return blockRayTrace;
        }
        return new RayTraceResult(block.getLocation().toVector());
    }

    @Override
    public org.bukkit.entity.Entity spawnInvisibleArmorStand(Location location) {
        WorldServer w = ((CraftWorld)location.getWorld()).getHandle();
        EntityArmorStand nmsEntity = new EntityArmorStand((World)w, location.getX(), location.getY(), location.getZ());
        nmsEntity.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        nmsEntity.setInvisible(true);
        w.addEntity((Entity)nmsEntity);
        return nmsEntity.getBukkitEntity();
    }

    @Override
    public PacketArmorStand createVirtualArmorStand(AbstractLocation location, PacketArmorStand.PacketArmorStandOptions options) {
        return new VirtualArmorStand(location, options);
    }

    @Override
    public PacketFallingBlock createVirtualBlock(BlockData blockData, AbstractLocation location) {
        return new VirtualFallingBlock(blockData, location);
    }

    @Override
    public PacketItem createVirtualItem(ItemStack item, AbstractLocation location) {
        return new VirtualItem(item, location);
    }
}

