/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.utils;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.items.ItemExecutor;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.mobs.MobType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TemplateUtil {
    static final ItemExecutor ITEM_EXECUTOR = MythicBukkit.inst().getItemManager();
    static final MobExecutor MOB_EXECUTOR = MythicBukkit.inst().getMobManager();

    public static void handleTemplates(ArrayList<TemplateMob> mobTemplates, Map<String, MythicMob> mmList) {
        HashMap stateMap = new HashMap();
        Map<String, TemplateMob> templates = mobTemplates.stream().collect(Collectors.toMap(TemplateMob::id, mob -> mob, (existing, replacement) -> existing));
        mobTemplates.forEach(mob -> TemplateUtil.processTemplate(mob, templates, stateMap, mmList));
    }

    public static void handleTemplates(ArrayList<TemplateItem> itemTemplates) {
        HashMap stateMap = new HashMap();
        Map<String, TemplateItem> templates = itemTemplates.stream().collect(Collectors.toMap(TemplateItem::id, item -> item, (existing, replacement) -> existing));
        itemTemplates.forEach(item -> TemplateUtil.processTemplate(item, templates, stateMap));
    }

    public static void processTemplate(TemplateMob mob, Map<String, TemplateMob> templates, Map<String, NodeState> state, Map<String, MythicMob> mmList) {
        NodeState mergeState = state.getOrDefault(mob.id(), NodeState.IDLE);
        if (mergeState == NodeState.BUSY) {
            MythicLogger.error("Cyclic template dependency found between {0} and {1}", mob.id(), mob.parentId());
            return;
        }
        if (mergeState == NodeState.FINISHED) {
            return;
        }
        state.put(mob.id(), NodeState.BUSY);
        if (mob.parentId() != null) {
            for (String s2 : mob.parentId().split(",")) {
                String parentID = s2.trim();
                TemplateMob parentTemplateMob = templates.get(parentID);
                if (parentTemplateMob == null && mmList.get(parentID) == null) {
                    MythicLogger.error("Invalid mob used as template in {0}: {1}", mob.id(), parentID);
                    return;
                }
                if (parentTemplateMob != null) {
                    TemplateUtil.processTemplate(parentTemplateMob, templates, state, mmList);
                }
                MythicConfigImpl parentConfig = parentTemplateMob != null ? parentTemplateMob.config() : mmList.get(parentID).getConfig();
                mob.config().merge(parentConfig, mob.config().getStringList("Exclude"));
            }
        }
        MobType mm4 = new MobType(MOB_EXECUTOR, mob.pack(), mob.file(), mob.id(), mob.config());
        mmList.put(mob.id(), mm4);
        state.put(mob.id(), NodeState.FINISHED);
    }

    public static void processTemplate(TemplateItem item, Map<String, TemplateItem> templates, Map<String, NodeState> state) {
        NodeState mergeState = state.getOrDefault(item.id(), NodeState.IDLE);
        if (mergeState == NodeState.BUSY) {
            MythicLogger.error("Cyclic template dependency found between {0} and {1}", item.id(), item.parentId());
            return;
        }
        if (mergeState == NodeState.FINISHED) {
            return;
        }
        state.put(item.id(), NodeState.BUSY);
        if (item.parentId() != null) {
            for (String parentID : item.parentId().split(",")) {
                MythicConfig parentConfig;
                TemplateItem parentTemplateMob = templates.get(parentID = parentID.trim());
                if (parentTemplateMob != null) {
                    TemplateUtil.processTemplate(parentTemplateMob, templates, state);
                    parentConfig = parentTemplateMob.config();
                } else {
                    Optional<MythicItem> parentItem = ITEM_EXECUTOR.getItem(item.parentId());
                    if (parentItem.isPresent()) {
                        parentConfig = parentItem.get().getConfig();
                    } else {
                        MythicLogger.error("Invalid item used as template in {0}: {1}", item.id(), item.parentId());
                        return;
                    }
                }
                item.config().merge(parentConfig, item.config().getStringList("Exclude"));
            }
        }
        ITEM_EXECUTOR.registerItem(item.id(), new MythicItem(item.pack(), item.file(), item.id(), item.config()));
        state.put(item.id(), NodeState.FINISHED);
    }

    public record TemplateMob(File file, Pack pack, String id, MythicConfigImpl config, String display, String parentId) {
    }

    static enum NodeState {
        IDLE,
        BUSY,
        FINISHED;

    }

    public record TemplateItem(Pack pack, File file, String id, MythicConfig config, String parentId) {
    }
}

