/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.types.AbstractVariable;
import io.lumine.mythic.core.skills.variables.types.FloatVariable;
import io.lumine.mythic.core.skills.variables.types.IntegerVariable;
import io.lumine.mythic.core.skills.variables.types.LocationVariable;
import io.lumine.mythic.core.skills.variables.types.StringVariable;
import io.lumine.mythic.core.skills.variables.types.VectorVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class VariableRegistry {
    private Map<String, Variable> entries;
    private final transient ReentrantLock lock = new ReentrantLock();

    public VariableRegistry() {
        this.entries = new HashMap<String, Variable>();
    }

    public VariableRegistry(Map<String, Variable> value) {
        Preconditions.checkNotNull(value);
        this.entries = value;
        this.clean();
    }

    public void put(String key, Variable value) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        this.lock.lock();
        try {
            this.entries.put(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<String, ? extends Variable> value) {
        Preconditions.checkNotNull(value);
        this.lock.lock();
        try {
            for (Map.Entry<String, ? extends Variable> entry : value.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(String key) {
        Preconditions.checkNotNull((Object)key);
        this.lock.lock();
        try {
            this.entries.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean has(String key) {
        Preconditions.checkNotNull((Object)key);
        this.lock.lock();
        try {
            Variable var = this.entries.getOrDefault(key, null);
            if (var == null || var.shouldExpire()) {
                this.entries.remove(key);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable get(String key) {
        Preconditions.checkNotNull((Object)key);
        this.lock.lock();
        try {
            Variable var = this.entries.getOrDefault(key, null);
            if (var == null || var.shouldExpire()) {
                this.entries.remove(key);
                Variable variable = null;
                return variable;
            }
            Variable variable = var;
            return variable;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable getOrDefault(String key, Variable def) {
        Preconditions.checkNotNull((Object)key);
        this.lock.lock();
        try {
            Variable var = this.entries.getOrDefault(key, null);
            if (var == null || var.shouldExpire()) {
                this.entries.remove(key);
                Variable variable = def;
                return variable;
            }
            Variable variable = var;
            return variable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void putInt(String key, int value) {
        this.put(key, new IntegerVariable(value));
    }

    public int getInt(String key) {
        Variable var;
        int def = 0;
        if (key.contains("|")) {
            String[] split = key.split("\\|");
            key = split[0];
            try {
                def = Integer.valueOf(split[1]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((var = this.get(key)) == null) {
            return def;
        }
        if (var instanceof IntegerVariable) {
            return ((IntegerVariable)var).getValue();
        }
        if (var instanceof FloatVariable) {
            return (int)((FloatVariable)var).getValue();
        }
        if (var instanceof StringVariable) {
            try {
                String value = ((StringVariable)var).getValue();
                return Integer.valueOf(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public void putString(String key, String value) {
        this.put(key, new StringVariable(value));
    }

    public String getString(String key) {
        Variable var;
        String def = "UNDEFINED";
        if (key.contains("|")) {
            String[] split = key.split("\\|");
            key = split[0];
            def = split[1];
        }
        if ((var = this.get(key)) == null) {
            return def;
        }
        if (var instanceof StringVariable) {
            return ((StringVariable)var).getValue();
        }
        if (var instanceof IntegerVariable) {
            return String.valueOf(((IntegerVariable)var).getValue());
        }
        if (var instanceof FloatVariable) {
            return String.valueOf(((FloatVariable)var).getValue());
        }
        return var.toString();
    }

    public void putFloat(String key, float value) {
        this.put(key, new FloatVariable(value));
    }

    public float getFloat(String key) {
        Variable var;
        float def = 0.0f;
        if (key.contains("|")) {
            String[] split = key.split("\\|");
            key = split[0];
            try {
                def = Float.valueOf(split[1]).floatValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((var = this.get(key)) == null) {
            return def;
        }
        if (var instanceof IntegerVariable) {
            return ((IntegerVariable)var).getValue();
        }
        if (var instanceof FloatVariable) {
            return ((FloatVariable)var).getValue();
        }
        if (var instanceof StringVariable) {
            try {
                String value = ((StringVariable)var).getValue();
                return Float.valueOf(value).floatValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public void putLocation(String key, AbstractLocation value) {
        this.put(key, new LocationVariable(value));
    }

    public void putVector(String key, AbstractVector value) {
        this.put(key, new VectorVariable(value));
    }

    public void putObject(String key, Object value) {
        this.put(key, new AbstractVariable(value));
    }

    public ImmutableMap<String, Variable> asMap() {
        this.lock.lock();
        try {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.entries);
            return immutableMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clean() {
        this.lock.lock();
        try {
            this.entries.values().removeIf(o -> o.shouldExpire());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void unload() {
        this.lock.lock();
        try {
            this.entries.values().removeIf(o -> !o.shouldSave());
        }
        finally {
            this.lock.unlock();
        }
    }
}

