/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.types.FloatVariable;
import io.lumine.mythic.core.skills.variables.types.IntegerVariable;
import io.lumine.mythic.core.skills.variables.types.LocationVariable;
import io.lumine.mythic.core.skills.variables.types.StringVariable;

public abstract class Variable {
    private long expirationTime = 0L;

    public Variable() {
        this.expirationTime = 0L;
    }

    public Variable(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public boolean shouldExpire() {
        return this.expirationTime <= 1L ? false : this.expirationTime <= System.currentTimeMillis();
    }

    public boolean shouldSave() {
        return !this.shouldExpire() && this.expirationTime != 1L;
    }

    public abstract Object get();

    public static Variable ofType(VariableType type, Object value) {
        return Variable.ofType(type, value, 0L);
    }

    public static Variable ofType(VariableType type, Object value, boolean save) {
        return Variable.ofType(type, value, save ? 0L : 1L);
    }

    public static Variable ofType(VariableType type, Object value, long expire) {
        switch (type) {
            case INTEGER: {
                int val = value instanceof String ? Integer.valueOf((String)value) : (value instanceof Number ? ((Number)value).intValue() : Integer.valueOf(String.valueOf(value)).intValue());
                return new IntegerVariable(val, expire);
            }
            case FLOAT: {
                float val = value instanceof String ? Float.valueOf((String)value).floatValue() : (value instanceof Number ? ((Number)value).floatValue() : Float.valueOf(String.valueOf(value)).floatValue());
                return new FloatVariable(val, expire);
            }
            case STRING: {
                String val = value instanceof String ? (String)value : String.valueOf(value);
                return new StringVariable(val, expire);
            }
            case LOCATION: {
                AbstractLocation location;
                AbstractLocation val = value instanceof AbstractLocation ? (location = (AbstractLocation)value) : null;
                return new LocationVariable(val, expire);
            }
        }
        return null;
    }

    public static Variable toType(Variable var, VariableType type) {
        return Variable.ofType(type, var.toString());
    }
}

