/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.triggers.meta;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.damage.DamageMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.triggers.SkillTriggerMetadata;
import java.util.Optional;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class PhysicalAttackMetadata
implements SkillTriggerMetadata {
    private final EntityDamageByEntityEvent event;
    private double damage;

    public PhysicalAttackMetadata(EntityDamageByEntityEvent event) {
        this.event = event;
        this.damage = event.getFinalDamage();
    }

    @Override
    public void applyToSkillMetadata(SkillMetadata skillMetadata) {
        AbstractEntity damaged = BukkitAdapter.adapt(this.event.getEntity());
        Optional<Object> maybeData = damaged.getMetadata("skill-damage");
        skillMetadata.getVariables().putString("damage-amount", String.valueOf(this.damage));
        if (maybeData.isPresent()) {
            DamageMetadata data = (DamageMetadata)maybeData.get();
            skillMetadata.getVariables().putObject("damage-metadata", data);
            skillMetadata.getVariables().putString("damage-cause", "SKILL");
            skillMetadata.getVariables().putString("real-damage-cause", this.event.getCause().toString());
            skillMetadata.getVariables().putString("damage-type", data.getElement() == null ? "SKILL" : data.getElement());
        } else {
            skillMetadata.getVariables().putString("damage-cause", this.event.getCause().toString());
        }
    }

    public EntityDamageByEntityEvent getEvent() {
        return this.event;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhysicalAttackMetadata)) {
            return false;
        }
        PhysicalAttackMetadata other = (PhysicalAttackMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getDamage(), other.getDamage()) != 0) {
            return false;
        }
        EntityDamageByEntityEvent this$event = this.getEvent();
        EntityDamageByEntityEvent other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PhysicalAttackMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $damage = Double.doubleToLongBits(this.getDamage());
        result = result * 59 + (int)($damage >>> 32 ^ $damage);
        EntityDamageByEntityEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "PhysicalAttackMetadata(event=" + this.getEvent() + ", damage=" + this.getDamage() + ")";
    }
}

