/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.RandomUtil;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;

@MythicTargeter(author="Ashijin", name="sphere", aliases={}, description="Targets points in a sphere around the caster")
public class SphereTargeter
extends ILocationSelector {
    private PlaceholderDouble radius;
    private PlaceholderDouble yOffset;
    private PlaceholderInt points;

    public SphereTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.radius = mlc.getPlaceholderDouble(new String[]{"radius", "r"}, 5.0, new String[0]);
        this.points = mlc.getPlaceholderInteger(new String[]{"points", "p"}, 10, new String[0]);
        this.yOffset = mlc.getPlaceholderDouble(new String[]{"yoffset", "y"}, 0.0, new String[0]);
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        ArrayList targets = Lists.newArrayList();
        AbstractLocation target = am.getLocation();
        AbstractLocation location = target.clone();
        location.add(0.0, this.yOffset.get(data), 0.0);
        for (int i = 0; i < this.points.get(data); ++i) {
            AbstractVector vector = RandomUtil.getRandomVector().multiply(this.radius.get(data));
            targets.add(location.clone().add(vector));
        }
        return targets;
    }
}

