/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;

@MythicTargeter(author="Ashijin", name="siblings", aliases={"sibling", "brothers", "sisters"}, description="Targets any child entities summoned by the caster's parent")
public class SiblingsTargeter
extends IEntitySelector {
    public SiblingsTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        ActiveMob am;
        ArrayList targets = Lists.newArrayList();
        SkillCaster skillCaster = data.getCaster();
        if (skillCaster instanceof ActiveMob && (am = (ActiveMob)skillCaster).getParent().isPresent()) {
            AbstractEntity parent = am.getParent().get();
            if (parent.isPlayer()) {
                PlayerData playerData = this.getPlugin().getPlayerManager().getProfile(parent.asPlayer());
            } else {
                ActiveMob parentMob = this.getPlugin().getMobManager().getMythicMobInstance(parent);
                if (parentMob != null && !parentMob.getEntity().isDead()) {
                    targets.addAll(parentMob.getChildren());
                }
            }
        }
        return targets;
    }
}

