/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;

@MythicTargeter(author="Ashijin", name="randomLocationsNearTargets", aliases={"randomLocationsNearTarget", "randomLocationsNearTargetEntities", "randomLocationsNearTargetLocations", "RLNT", "RLNTE", "RLNTL"}, description="Targets random locations near the inherited targets")
public class RandomLocationsNearTargetsTargeter
extends ILocationSelector {
    private PlaceholderInt amount;
    private int maxRadius;
    private int minRadius;
    private int minRadiusSq;
    private int spacing;
    private int spacingSq;

    public RandomLocationsNearTargetsTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 5, new String[0]);
        this.maxRadius = mlc.getInteger(new String[]{"radius", "r", "maxradius", "maxr"}, 5);
        this.minRadius = mlc.getInteger(new String[]{"minradius", "minr"}, 0);
        this.spacing = mlc.getInteger(new String[]{"spacing", "s"}, 0);
        this.minRadiusSq = this.minRadius * this.minRadius;
        this.spacingSq = this.spacing * this.spacing;
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        ArrayList targets;
        block9: {
            int amountSq;
            int amount;
            block8: {
                targets = Lists.newArrayList();
                amount = this.amount.get(data);
                amountSq = amount * amount;
                if (data.getEntityTargets() == null || data.getEntityTargets().isEmpty()) break block8;
                for (AbstractEntity e : data.getEntityTargets()) {
                    int i = 0;
                    int j = 0;
                    while (i < amount && j < amountSq) {
                        ++j;
                        MythicBukkit.inst().getMobManager();
                        AbstractLocation l = MobExecutor.findSafeSpawnLocation(e.getLocation(), this.maxRadius, 1.0, 1, true, false);
                        if (this.minRadius > 0 && l.distanceSquared(e.getLocation()) < (double)this.minRadiusSq) continue;
                        if (this.spacing > 0) {
                            boolean bad = false;
                            for (AbstractLocation l2 : targets) {
                                if (!(l.distanceSquared(l2) < (double)this.spacingSq)) continue;
                                bad = true;
                                break;
                            }
                            if (bad) continue;
                        }
                        targets.add(l);
                        ++i;
                    }
                }
                break block9;
            }
            if (data.getLocationTargets() == null || data.getLocationTargets().isEmpty()) break block9;
            for (AbstractLocation e : data.getLocationTargets()) {
                int i = 0;
                int j = 0;
                while (i < amount && j < amountSq) {
                    ++j;
                    MythicBukkit.inst().getMobManager();
                    AbstractLocation l = MobExecutor.findSafeSpawnLocation(e, this.maxRadius, 1.0, 1, true, false);
                    if (this.minRadius > 0 && l.distanceSquared(e) < (double)this.minRadiusSq) continue;
                    if (this.spacing > 0) {
                        boolean bad = false;
                        for (AbstractLocation l2 : targets) {
                            if (!(l.distanceSquared(l2) < (double)this.spacingSq)) continue;
                            bad = true;
                            break;
                        }
                        if (bad) continue;
                    }
                    targets.add(l);
                    ++i;
                }
            }
        }
        return targets;
    }
}

