/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;

@MythicTargeter(author="Ashijin", name="projectileforward", aliases={""}, description="Targets a point in front of the casting projectile")
public class ProjectileForwardTargeter
extends ILocationSelector {
    protected double forward;
    protected float rotate;
    protected boolean rotated = false;

    public ProjectileForwardTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.forward = mlc.getDouble(new String[]{"forward", "f", "amount", "a"}, 1.0);
        this.rotate = mlc.getFloat(new String[]{"rotate", "rot"}, 0.0f);
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        ArrayList targets = Lists.newArrayList();
        IParentSkill callingEvent = data.getCallingEvent();
        if (!(callingEvent instanceof Projectile.ProjectileTracker)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "ProjectileForwardTargeter called by non-projectile, skipping", new Object[0]);
            return targets;
        }
        Projectile.ProjectileTracker tracker = (Projectile.ProjectileTracker)callingEvent;
        AbstractLocation location = tracker.getCurrentLocation().clone();
        AbstractVector direction = tracker.getCurrentVelocity().clone();
        if (this.rotate != 0.0f) {
            location.add(direction.rotate(this.rotate).normalize().multiply(this.forward));
        } else {
            location.add(direction.normalize().multiply(this.forward));
        }
        targets.add(this.mutate(data, location));
        return targets;
    }
}

