/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class MobsInRadiusTargeter
extends IEntitySelector {
    private double radius;
    private double radiusSq;
    private HashSet<MythicMob> mmTypes = new HashSet();
    private HashSet<BukkitEntityType> meTypes = new HashSet();

    public MobsInRadiusTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.radius = mlc.getDouble(new String[]{"radius", "r"}, 5.0);
        this.radiusSq = Math.pow(this.radius, 2.0);
        String types = mlc.getString(new String[]{"types", "type", "t"}, "", new String[0]);
        String[] ss = types.split(",");
        MobsInRadiusTargeter THIS = this;
        this.getPlugin().getSkillManager().queueSecondPass(() -> {
            for (String s2 : ss) {
                MythicMob mm4 = MythicBukkit.inst().getMobManager().getMythicMob(s2).orElseGet(() -> null);
                if (mm4 != null) {
                    THIS.mmTypes.add(mm4);
                    continue;
                }
                BukkitEntityType me = BukkitEntityType.getMythicEntity(s2);
                if (me != null) {
                    THIS.meTypes.add(me);
                    continue;
                }
                MythicLogger.errorTargeterConfig(this, mlc, "The 'type' attribute must be a valid MythicMob or MythicEntity type.");
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "@MIR targeter loaded targeting " + (THIS.meTypes.size() + THIS.mmTypes.size()) + " types", new Object[0]);
        });
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        AbstractEntity caster = am.getEntity();
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        if (this.radius > 128.0) {
            ArrayList toCheck = Lists.newArrayList(this.getPlugin().getEntityManager().getLivingEntities(am.getEntity().getWorld()));
            block0: for (AbstractEntity p : toCheck) {
                if (p.getUniqueId().equals(am.getEntity().getUniqueId()) || !p.getWorld().equals(am.getEntity().getWorld()) || !(am.getEntity().getLocation().distanceSquared(p.getLocation()) <= this.radiusSq)) continue;
                ActiveMob amx = this.getPlugin().getMobManager().getMythicMobInstance(p);
                if (amx != null) {
                    if (!this.mmTypes.contains(amx.getType())) continue;
                    targets.add(p);
                    amx = null;
                    continue;
                }
                for (BukkitEntityType me : this.meTypes) {
                    if (!me.compare(p.getBukkitEntity())) continue;
                    targets.add(p);
                    continue block0;
                }
            }
        } else {
            targets.addAll(this.getPlugin().getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(am.getLocation(), this.radius, entity -> {
                if (entity.getUniqueId().equals(am.getEntity().getUniqueId())) {
                    return false;
                }
                if (caster.getLocation().distanceSquared(entity.getLocation()) > this.radiusSq) {
                    return false;
                }
                if (!this.getPlugin().getMobManager().isLoadedMob((AbstractEntity)entity)) {
                    return false;
                }
                ActiveMob amCompare = this.getPlugin().getMobManager().getMythicMobInstance((AbstractEntity)entity);
                if (amCompare != null) {
                    if (this.mmTypes.contains(amCompare.getType())) {
                        return true;
                    }
                } else {
                    for (BukkitEntityType me : this.meTypes) {
                        if (!me.compare(entity.getBukkitEntity())) continue;
                        return true;
                    }
                }
                return false;
            }));
        }
        return targets;
    }
}

