/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BoundingBox;

@MythicTargeter(author="Ashijin", name="floorOfTargets", aliases={"floorsOfTarget", "FOT"}, description="Targets the first solid block below the inherited targets")
public class FloorOfTargetsTargeter
extends ILocationSelector {
    private int tries = 3;

    public FloorOfTargetsTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.tries = mlc.getInteger(new String[]{"tries", "t", "max", "m"}, 3);
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT targeter", new Object[0]);
        if (data.getEntityTargets() != null) {
            block0: for (AbstractEntity entity : data.getEntityTargets()) {
                BoundingBox boundingBox = entity.getBukkitEntity().getBoundingBox();
                Block block = BukkitAdapter.adapt(entity.getLocation()).getBlock().getRelative(BlockFace.DOWN);
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT targeter checking {0} at {1}", entity.getName(), block.getLocation().toString());
                for (int i = 0; i < this.tries; ++i) {
                    if (block.getType() != Material.AIR) {
                        AbstractLocation target = this.mutate(data, BukkitAdapter.adapt(block.getLocation()));
                        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT targeting location {0}", target);
                        targets.add(target);
                        continue block0;
                    }
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT checking blocks in BB {0}", boundingBox.toString());
                    boundingBox = boundingBox.shift(0.0, -0.05, 0.0);
                    boundingBox = boundingBox.expand(0.333, 0.0, 0.333);
                    double minX = boundingBox.getMinX();
                    double minY = boundingBox.getMinY();
                    double minZ = boundingBox.getMinZ();
                    double maxX = boundingBox.getMaxX();
                    double maxY = boundingBox.getMaxY();
                    double maxZ = boundingBox.getMaxZ();
                    for (double lx = minX; lx <= maxX; lx += 1.0) {
                        for (double ly = minY; ly <= maxY; ly += 1.0) {
                            for (double lz = minZ; lz <= maxZ; lz += 1.0) {
                                Block checkBlock = new Location(block.getWorld(), lx, ly, lz).getBlock();
                                if (!checkBlock.isPassable()) {
                                    AbstractLocation target = this.mutate(data, BukkitAdapter.adapt(checkBlock.getLocation()));
                                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT targeting location {0}", target);
                                    targets.add(target);
                                    continue;
                                }
                                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT Position {0} invalid", checkBlock.toString());
                            }
                        }
                    }
                    if (targets.size() > 0) continue block0;
                    block = block.getRelative(BlockFace.DOWN);
                }
            }
        } else if (data.getLocationTargets() != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT checking locations", new Object[0]);
            block5: for (AbstractLocation e : data.getLocationTargets()) {
                Block block = BukkitAdapter.adapt(e).getBlock().getRelative(BlockFace.DOWN);
                for (int i = 0; i < this.tries; ++i) {
                    if (block.getType() == Material.AIR) continue;
                    targets.add(this.mutate(data, BukkitAdapter.adapt(block.getLocation())));
                    continue block5;
                }
            }
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT inherited nothing", new Object[0]);
        }
        return targets;
    }
}

