/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;

@MythicTargeter(author="Pineapple", name="entitiesInRing", aliases={"EIRR"}, description="Targets all entities in a ring")
public class EntitiesInRingTargeter
extends IEntitySelector {
    protected PlaceholderDouble min;
    protected PlaceholderDouble max;

    public EntitiesInRingTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.min = mlc.getPlaceholderDouble(new String[]{"min", "minrange"}, 5.0, new String[0]);
        this.max = mlc.getPlaceholderDouble(new String[]{"max", "maxrange"}, 10.0, new String[0]);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        for (AbstractEntity e : MythicBukkit.inst().getEntityManager().getLivingEntities(am.getEntity().getWorld())) {
            if (!am.getLocation().getWorld().equals(e.getWorld()) || !(am.getEntity().getLocation().distanceSquared(e.getLocation()) < Math.pow(this.max.get(data), 2.0)) || !(am.getEntity().getLocation().distanceSquared(e.getLocation()) > Math.pow(this.min.get(data), 2.0))) continue;
            targets.add(e);
        }
        return targets;
    }
}

