/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.stats.types;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicStatChangeEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.stats.StatExecutor;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatType;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

public class CompositeStat
extends StatType {
    private static final StringProp FORMULA = Property.String(Scope.STATS, "Formula", "0");
    private static final StringListProp PARENTS = Property.StringList(Scope.STATS, "ParentStats");
    private Expression expression;
    private final Collection<StatType> parentStats = Sets.newConcurrentHashSet();
    private final ReentrantLock lock = new ReentrantLock();

    public CompositeStat(String key) {
        super(key);
    }

    @Override
    protected void load(StatExecutor manager) {
        for (String key : (List)PARENTS.get(this)) {
            Optional<StatType> maybeStat = this.getManager().getStat(key);
            if (maybeStat.isEmpty()) {
                MythicLogger.error("Invalid parent stat {0}", key);
                return;
            }
            this.parentStats.add(maybeStat.get());
        }
        String formula = (String)FORMULA.get(this);
        try {
            ExpressionBuilder builder = new ExpressionBuilder(formula).operator(Operators.operators).functions(Functions.functions);
            for (StatType parentStat : this.parentStats) {
                builder.variable(parentStat.getFormulaKey());
                MythicLogger.log("added variable {0}", parentStat.getFormulaKey());
            }
            this.expression = builder.build();
        }
        catch (Exception ex) {
            MythicLogger.error("Invalid stat formula defined: " + formula);
            ex.printStackTrace();
            this.expression = new ExpressionBuilder("0").build();
            return;
        }
        Events.subscribe(MythicStatChangeEvent.class).handler(event -> {
            SkillCaster caster = event.getCaster();
            MythicLogger.log("aaaaaaaaaa");
            if (!this.parentStats.contains(event.getStat())) {
                MythicLogger.log("Stat {0} not parent", event.getStat().getKey());
                return;
            }
            if (caster instanceof ActiveMob) {
                ActiveMob am = (ActiveMob)caster;
            } else if (caster.getEntity().isPlayer()) {
                PlayerData profile = ((MythicBukkit)this.getManager().getPlugin()).getPlayerManager().getProfile(caster.getEntity().asPlayer());
                StatRegistry stats = profile.getStats();
                MythicLogger.log("aaaaaa");
                stats.putBaseValue(this, this.calculateBaseValue(stats));
            }
        }).bindWith(this);
    }

    @Override
    public boolean isApplicable(AbstractEntity entity) {
        return entity.isPlayer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double calculateBaseValue(StatRegistry statRegistry) {
        this.lock.lock();
        try {
            Expression expression = this.expression;
            for (StatType parentStat : this.parentStats) {
                expression.setVariable(parentStat.getFormulaKey(), statRegistry.get(parentStat));
            }
            double val = expression.evaluate();
            MythicLogger.log("Base value is {0}", val);
            double d = val;
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }
}

