/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.stats;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.config.properties.types.DoubleProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythic.bukkit.utils.terminable.TerminableRegistry;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.stats.StatExecutor;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.triggers.SkillTriggerMetadata;
import java.util.Collection;

public abstract class StatType
implements PropertyHolder,
Terminable,
TerminableConsumer {
    private static final StringProp DISPLAY = Property.String(Scope.STATS, "Display", "");
    private static final StringProp FORMULA = Property.String(Scope.STATS, "Formula", "");
    private static final StringProp FORMULA_KEY = Property.String(Scope.STATS, "FormulaKey", null);
    private static final DoubleProp BASE_VALUE = Property.Double(Scope.STATS, "BaseValue", 0.0);
    private final TerminableRegistry registry = TerminableRegistry.create();
    private StatExecutor manager;
    private final String key;
    private final String formulaKey;
    private final Collection<SkillTrigger> applicableTriggers = Sets.newConcurrentHashSet();
    private boolean initialized = false;

    public StatType(String key) {
        this.key = key;
        String formulaKey = (String)FORMULA_KEY.get(this);
        this.formulaKey = formulaKey == null ? key : formulaKey;
    }

    public void initialize(StatExecutor manager) {
        if (this.initialized) {
            return;
        }
        this.manager = manager;
        this.load(manager);
        this.initialized = true;
    }

    protected abstract void load(StatExecutor var1);

    public abstract boolean isApplicable(AbstractEntity var1);

    public double getStat(AbstractEntity entity) {
        if (entity.isPlayer()) {
            PlayerData profile = MythicBukkit.inst().getPlayerManager().getProfile(entity.asPlayer());
            StatRegistry stats = profile.getStats();
            return stats.get(this);
        }
        return 0.0;
    }

    public String getDisplay() {
        return this.key;
    }

    public double getBaseValue() {
        return 0.0;
    }

    public boolean isApplicable(SkillTrigger trigger) {
        return this.applicableTriggers.contains(trigger);
    }

    public void processTrigger(SkillTriggerMetadata metadata) {
    }

    @Override
    public String getPropertyNode() {
        return this.key;
    }

    @Override
    public <T extends AutoCloseable> T bind(T binding) {
        this.registry.accept((Terminable)binding);
        return binding;
    }

    @Override
    public void close() throws Exception {
        this.registry.terminate();
    }

    public StatExecutor getManager() {
        return this.manager;
    }

    public String getKey() {
        return this.key;
    }

    public String getFormulaKey() {
        return this.formulaKey;
    }

    public Collection<SkillTrigger> getApplicableTriggers() {
        return this.applicableTriggers;
    }
}

