/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.stats;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.bukkit.events.MythicStatChangeEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.core.skills.stats.StatModifierType;
import io.lumine.mythic.core.skills.stats.StatSource;
import io.lumine.mythic.core.skills.stats.StatType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class StatRegistry {
    private final SkillCaster holder;
    private final Map<StatType, StatMap> stats = Maps.newConcurrentMap();

    public StatRegistry(SkillCaster holder) {
        this.holder = holder;
    }

    public double get(StatType type) {
        return this.stats.computeIfAbsent(type, x -> new StatMap(type)).get();
    }

    public void putBaseValue(StatType type, double value) {
        this.stats.computeIfAbsent(type, x -> new StatMap(type)).setBaseValue(value);
    }

    public void putValue(StatType type, StatSource source, StatModifierType operation, double value) {
        this.stats.computeIfAbsent(type, x -> new StatMap(type)).put(source, operation, value);
    }

    public void removeValue(StatType type, StatSource source) {
        StatMap stat = this.stats.get(type);
        if (stat != null) {
            stat.remove(source);
        }
    }

    public Collection<StatType> getApplicableStats() {
        return Collections.unmodifiableCollection(this.stats.keySet());
    }

    public Collection<StatType> getApplicableStats(SkillTrigger trigger) {
        return this.stats.keySet().stream().filter(stat -> stat.isApplicable(trigger)).collect(Collectors.toUnmodifiableSet());
    }

    public Optional<StatMap> getStatData(StatType type) {
        return Optional.ofNullable(this.stats.getOrDefault(type, null));
    }

    public boolean isEmpty() {
        return this.stats.isEmpty();
    }

    public HashMap<String, Double> getBaseStats() {
        HashMap map = Maps.newHashMap();
        for (StatMap statMap : this.stats.values()) {
            StatType type = statMap.getType();
            double baseValue = statMap.getBaseValue();
            map.put(type.getKey(), baseValue);
        }
        return map;
    }

    public SkillCaster getHolder() {
        return this.holder;
    }

    public class StatMap {
        private final StatType type;
        private double baseValue = 1.0;
        private final Map<StatSource, Double> additives = Maps.newConcurrentMap();
        private final Map<StatSource, Double> additiveMultipliers = Maps.newConcurrentMap();
        private final Map<StatSource, Double> compoundMultipliers = Maps.newConcurrentMap();
        private final Map<StatSource, StatModifierType> typeMap = Maps.newConcurrentMap();
        private double cachedAdditives = 0.0;
        private double cachedAdditiveMultipliers = 1.0;
        private double cachedValue = 0.0;

        public StatMap(StatType type) {
            this.type = type;
            this.baseValue = type.getBaseValue();
        }

        public void setBaseValue(double value) {
            this.baseValue = value;
            this.calculateCachedValue();
        }

        public void calculateCachedValue() {
            double cachedValue = this.baseValue + this.additives.values().stream().mapToDouble(Double::doubleValue).sum();
            if (!this.additiveMultipliers.isEmpty()) {
                cachedValue *= this.additiveMultipliers.values().stream().mapToDouble(Double::doubleValue).sum();
            }
            if (!this.compoundMultipliers.isEmpty()) {
                for (Double value : this.compoundMultipliers.values()) {
                    cachedValue *= value.doubleValue();
                }
            }
            if (cachedValue != this.cachedValue) {
                try {
                    double oldValue = this.cachedValue;
                    this.cachedValue = cachedValue;
                    Events.call(new MythicStatChangeEvent(StatRegistry.this.holder, this.type, oldValue, cachedValue));
                }
                catch (Error | Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void put(StatSource source, StatModifierType operation, double value) {
            switch (operation) {
                case ADDITIVE: {
                    this.additives.put(source, value);
                    this.cachedAdditives = this.additives.values().stream().mapToDouble(Double::doubleValue).sum();
                    break;
                }
                case ADDITIVE_MULTIPLIER: {
                    this.additiveMultipliers.put(source, value);
                    this.cachedAdditiveMultipliers = 1.0 + this.additiveMultipliers.values().stream().mapToDouble(Double::doubleValue).sum();
                    break;
                }
                case COMPOUND_MULTIPLIER: {
                    this.compoundMultipliers.put(source, value);
                }
            }
            this.typeMap.put(source, operation);
            this.calculateCachedValue();
        }

        public void remove(StatSource source) {
            StatModifierType operation = this.typeMap.remove(source);
            if (operation == null) {
                return;
            }
            switch (operation) {
                case ADDITIVE: {
                    this.additives.remove(source);
                    this.cachedAdditives = this.additives.values().stream().mapToDouble(Double::doubleValue).sum();
                    break;
                }
                case ADDITIVE_MULTIPLIER: {
                    this.additiveMultipliers.remove(source);
                    this.cachedAdditiveMultipliers = 1.0 + this.additiveMultipliers.values().stream().mapToDouble(Double::doubleValue).sum();
                    break;
                }
                case COMPOUND_MULTIPLIER: {
                    this.compoundMultipliers.remove(source);
                }
            }
            this.calculateCachedValue();
        }

        public double get() {
            return this.cachedValue;
        }

        public StatType getType() {
            return this.type;
        }

        public double getBaseValue() {
            return this.baseValue;
        }

        public Map<StatSource, Double> getAdditives() {
            return this.additives;
        }

        public Map<StatSource, Double> getAdditiveMultipliers() {
            return this.additiveMultipliers;
        }

        public Map<StatSource, Double> getCompoundMultipliers() {
            return this.compoundMultipliers;
        }

        public Map<StatSource, StatModifierType> getTypeMap() {
            return this.typeMap;
        }

        public double getCachedAdditives() {
            return this.cachedAdditives;
        }

        public double getCachedAdditiveMultipliers() {
            return this.cachedAdditiveMultipliers;
        }

        public double getCachedValue() {
            return this.cachedValue;
        }

        public void setCachedAdditives(double cachedAdditives) {
            this.cachedAdditives = cachedAdditives;
        }

        public void setCachedAdditiveMultipliers(double cachedAdditiveMultipliers) {
            this.cachedAdditiveMultipliers = cachedAdditiveMultipliers;
        }

        public void setCachedValue(double cachedValue) {
            this.cachedValue = cachedValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatMap)) {
                return false;
            }
            StatMap other = (StatMap)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getBaseValue(), other.getBaseValue()) != 0) {
                return false;
            }
            if (Double.compare(this.getCachedAdditives(), other.getCachedAdditives()) != 0) {
                return false;
            }
            if (Double.compare(this.getCachedAdditiveMultipliers(), other.getCachedAdditiveMultipliers()) != 0) {
                return false;
            }
            if (Double.compare(this.getCachedValue(), other.getCachedValue()) != 0) {
                return false;
            }
            StatType this$type = this.getType();
            StatType other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Map<StatSource, Double> this$additives = this.getAdditives();
            Map<StatSource, Double> other$additives = other.getAdditives();
            if (this$additives == null ? other$additives != null : !((Object)this$additives).equals(other$additives)) {
                return false;
            }
            Map<StatSource, Double> this$additiveMultipliers = this.getAdditiveMultipliers();
            Map<StatSource, Double> other$additiveMultipliers = other.getAdditiveMultipliers();
            if (this$additiveMultipliers == null ? other$additiveMultipliers != null : !((Object)this$additiveMultipliers).equals(other$additiveMultipliers)) {
                return false;
            }
            Map<StatSource, Double> this$compoundMultipliers = this.getCompoundMultipliers();
            Map<StatSource, Double> other$compoundMultipliers = other.getCompoundMultipliers();
            if (this$compoundMultipliers == null ? other$compoundMultipliers != null : !((Object)this$compoundMultipliers).equals(other$compoundMultipliers)) {
                return false;
            }
            Map<StatSource, StatModifierType> this$typeMap = this.getTypeMap();
            Map<StatSource, StatModifierType> other$typeMap = other.getTypeMap();
            return !(this$typeMap == null ? other$typeMap != null : !((Object)this$typeMap).equals(other$typeMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StatMap;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $baseValue = Double.doubleToLongBits(this.getBaseValue());
            result = result * 59 + (int)($baseValue >>> 32 ^ $baseValue);
            long $cachedAdditives = Double.doubleToLongBits(this.getCachedAdditives());
            result = result * 59 + (int)($cachedAdditives >>> 32 ^ $cachedAdditives);
            long $cachedAdditiveMultipliers = Double.doubleToLongBits(this.getCachedAdditiveMultipliers());
            result = result * 59 + (int)($cachedAdditiveMultipliers >>> 32 ^ $cachedAdditiveMultipliers);
            long $cachedValue = Double.doubleToLongBits(this.getCachedValue());
            result = result * 59 + (int)($cachedValue >>> 32 ^ $cachedValue);
            StatType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Map<StatSource, Double> $additives = this.getAdditives();
            result = result * 59 + ($additives == null ? 43 : ((Object)$additives).hashCode());
            Map<StatSource, Double> $additiveMultipliers = this.getAdditiveMultipliers();
            result = result * 59 + ($additiveMultipliers == null ? 43 : ((Object)$additiveMultipliers).hashCode());
            Map<StatSource, Double> $compoundMultipliers = this.getCompoundMultipliers();
            result = result * 59 + ($compoundMultipliers == null ? 43 : ((Object)$compoundMultipliers).hashCode());
            Map<StatSource, StatModifierType> $typeMap = this.getTypeMap();
            result = result * 59 + ($typeMap == null ? 43 : ((Object)$typeMap).hashCode());
            return result;
        }

        public String toString() {
            return "StatRegistry.StatMap(type=" + this.getType() + ", baseValue=" + this.getBaseValue() + ", additives=" + this.getAdditives() + ", additiveMultipliers=" + this.getAdditiveMultipliers() + ", compoundMultipliers=" + this.getCompoundMultipliers() + ", typeMap=" + this.getTypeMap() + ", cachedAdditives=" + this.getCachedAdditives() + ", cachedAdditiveMultipliers=" + this.getCachedAdditiveMultipliers() + ", cachedValue=" + this.getCachedValue() + ")";
        }
    }
}

