/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.stats;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.types.NodeListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatType;
import io.lumine.mythic.core.skills.stats.Stats;
import io.lumine.mythic.core.skills.stats.types.CompositeStat;
import io.lumine.mythic.core.skills.stats.types.StaticStat;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class StatExecutor
extends ReloadableModule<MythicBukkit> {
    private static final NodeListProp STATS = Property.NodeList(Scope.STATS, "");
    private static final StringProp STAT_TYPE = Property.String(Scope.STATS, "Type", "STATIC");
    private final Map<String, StatType> stats = Maps.newConcurrentMap();
    private final Map<SkillTrigger, StatType> triggerModifyingStats = Maps.newConcurrentMap();

    public StatExecutor(MythicBukkit plugin) {
        super(plugin, false);
        this.load(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.registerPrimaryStat(Stats.PERCENT_DAMAGE);
        for (String node : (Set)STATS.get()) {
            MythicLogger.log("Loading stat {0}", node);
            this.registerStat(node);
        }
        this.loadStats();
    }

    @Override
    public void unload() {
        for (StatType stat : this.stats.values()) {
            stat.terminate();
        }
        this.stats.clear();
    }

    private void registerPrimaryStat(StatType type) {
        if (this.stats.containsKey(type.getPropertyNode())) {
            return;
        }
        this.stats.put(type.getPropertyNode(), type);
    }

    private void registerStat(String key) {
        if (this.stats.containsKey(key)) {
            return;
        }
        MythicLogger.log("Loaded custom stat {0}", key);
        String type = (String)STAT_TYPE.get(key);
        StatType stat = null;
        switch (type.toUpperCase()) {
            case "COMPOSITE": {
                stat = new CompositeStat(key);
                break;
            }
            case "STATIC": {
                stat = new StaticStat(key);
                break;
            }
            default: {
                stat = new StaticStat(key);
            }
        }
        if (stat != null) {
            this.stats.put(key, stat);
        }
    }

    private void loadStats() {
        this.stats.values().forEach(stat -> stat.initialize(this));
    }

    public Optional<StatType> getStat(String statName) {
        return Optional.ofNullable(this.stats.getOrDefault(statName, null));
    }

    public StatType getStatOrRegisterStatic(String statName) {
        return this.stats.compute(statName, (key, stat) -> stat == null ? new StaticStat((String)key) : stat);
    }

    public Optional<StatRegistry> getStatRegistry(AbstractEntity entity) {
        if (entity.isPlayer()) {
            PlayerData profile = ((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(entity.asPlayer());
            if (profile == null) {
                return Optional.empty();
            }
            StatRegistry registry = profile.getStats();
            return Optional.of(registry);
        }
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(entity);
        if (am == null) {
            return Optional.empty();
        }
        return Optional.of(am.getStatRegistry());
    }
}

