/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.projectiles.bullet;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.api.volatilecode.virtual.PacketTextDisplayEntity;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.projectiles.ProjectileBullet;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletType;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Collection;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.util.Vector;

public class TextDisplayPacketBullet
extends ProjectileBullet {
    @MythicField(name="audience", description="The audience of the message")
    protected SkillAudience audience;
    @MythicField(name="bulletText", aliases={"text"}, description="The text of the bullet", defValue="*")
    protected PlaceholderString bulletText = null;
    @MythicField(name="bulletBillboard", aliases={"billboard"}, description="The billboard mode of the bullet", defValue="CENTER")
    protected Display.Billboard bulletBillboard = Display.Billboard.CENTER;
    @MythicField(name="bulletScale", description="The bullet's size scale")
    protected AbstractVector bulletScale;
    @MythicField(name="backgroundColor", aliases={"color"}, description="The background color to use", defValue="1073741824")
    private Color backgroundColor;
    private PacketTextDisplayEntity.PacketTextDisplayEntityOptions options;

    public TextDisplayPacketBullet(ProjectileBulletType type, Projectile projectile, MythicLineConfig config) {
        super(type, projectile, config);
        this.audience = config.getAudience("audience", "world");
        this.bulletText = config.getPlaceholderString(new String[]{"bulletText", "text"}, "*", new String[0]);
        String strBulletScale = config.getString(new String[]{"bulletscale", "scale"}, "0.5,0.5,0.5", new String[0]);
        try {
            String[] splitStr = strBulletScale.split(",");
            double x = Double.parseDouble(splitStr[0]);
            double y = Double.parseDouble(splitStr[1]);
            double z = Double.parseDouble(splitStr[2]);
            this.bulletScale = new AbstractVector(x, y, z);
        }
        catch (Throwable ex) {
            this.bulletScale = new AbstractVector(0.5, 0.5, 0.5);
            MythicLogger.errorMechanic(projectile, "Invalid bullet scale set: " + strBulletScale);
        }
        String strBulletBillboard = config.getString(new String[]{"bulletbillboard", "billboard"}, "CENTER", new String[0]);
        try {
            this.bulletBillboard = Display.Billboard.valueOf((String)strBulletBillboard.toUpperCase());
        }
        catch (Throwable ex) {
            this.bulletBillboard = Display.Billboard.CENTER;
            MythicLogger.errorMechanic(projectile, "Invalid bullet billboard mode: " + strBulletBillboard);
        }
        String colorStr = config.getString(new String[]{"backgroundcolor", "color"}, "64,0,0,0", new String[0]);
        try {
            String[] splitStr = colorStr.split(",");
            int a = Integer.parseInt(splitStr[0]);
            int r = Integer.parseInt(splitStr[1]);
            int g2 = Integer.parseInt(splitStr[2]);
            int b = Integer.parseInt(splitStr[3]);
            this.backgroundColor = Color.fromARGB((int)a, (int)r, (int)g2, (int)b);
        }
        catch (Throwable e) {
            this.backgroundColor = Color.fromARGB((int)64, (int)0, (int)0, (int)0);
            MythicLogger.errorMechanic(projectile, "Invalid bullet background color set: " + colorStr);
        }
        this.options = PacketTextDisplayEntity.PacketTextDisplayEntityOptions.builder().text(this.bulletText.get()).billboard(this.bulletBillboard).scale(this.bulletScale).backgroundColor(this.backgroundColor).build();
    }

    @Override
    public ProjectileBullet.BulletTracker create(Projectile.ProjectileTracker projectile, AbstractEntity target) {
        return new ArmorStandBulletTracker(projectile, target);
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    public class ArmorStandBulletTracker
    extends ProjectileBullet.BulletTracker {
        protected PacketEntity mount;
        protected PacketTextDisplayEntity bullet;

        public ArmorStandBulletTracker(Projectile.ProjectileTracker projectile, AbstractEntity target) {
            super(projectile, target);
        }

        @Override
        public void spawn(AbstractLocation start) {
            AbstractLocation l = start.clone();
            this.mount = TextDisplayPacketBullet.this.getPlugin().getVolatileCodeHandler().getWorldHandler().createVirtualArmorStand(l);
            this.bullet = TextDisplayPacketBullet.this.getPlugin().getVolatileCodeHandler().getWorldHandler().createVirtualTextDisplayEntity(l, TextDisplayPacketBullet.this.options);
            AbstractLocation currentLocation = this.getProjectile().getPreviousLocation();
            AbstractVector currentVelocity = this.getProjectile().getCurrentVelocity();
            Location to = BukkitAdapter.adapt(currentLocation).clone();
            Vector delta = BukkitAdapter.adapt(currentVelocity).normalize().multiply(this.getProjectile().getVelocityMagnitude() / 7.6);
            double yaw = Math.atan2(delta.getX(), delta.getZ());
            double len = delta.getZ() / Math.cos(yaw);
            float pitch = (float)Math.atan2(delta.getY(), len);
            Location loc = to.clone().add(delta);
            float newYaw = (float)Math.toDegrees(-yaw) + 180.0f;
            float newPitch = (float)Math.toDegrees(-pitch);
            loc.setYaw(newYaw);
            loc.setPitch(newPitch);
            Collection<AbstractPlayer> seen = TextDisplayPacketBullet.this.audience.get(this.getProjectile().getData(), this.getTarget());
            this.mount.spawn(seen);
            this.bullet.spawn(seen);
            this.mount.addPassenger(this.bullet);
            Schedulers.async().runLater(() -> this.mount.addPassenger(this.bullet), 1L);
        }

        @Override
        public void tick(AbstractLocation origin) {
            if (this.getProjectile().getTimesRan() % 5 == 0) {
                this.bullet.updateRenderedPlayers();
            }
            AbstractLocation currentLocation = this.getProjectile().getPreviousLocation();
            AbstractVector currentVelocity = this.getProjectile().getCurrentVelocity();
            Location to = BukkitAdapter.adapt(currentLocation).clone();
            Vector delta = BukkitAdapter.adapt(currentVelocity).normalize().multiply(this.getProjectile().getVelocityMagnitude() / 7.6);
            double yaw = Math.atan2(delta.getX(), delta.getZ());
            double len = delta.getZ() / Math.cos(yaw);
            float pitch = (float)Math.atan2(delta.getY(), len);
            Location loc = to.clone().add(delta);
            float newYaw = (float)Math.toDegrees(-yaw) + 180.0f;
            float newPitch = (float)Math.toDegrees(-pitch);
            loc.setYaw(newYaw);
            loc.setPitch(newPitch);
            this.bullet.setRotation(newYaw, newPitch);
            this.bullet.update(BukkitAdapter.adapt(loc));
            this.mount.update(BukkitAdapter.adapt(loc));
        }

        @Override
        public void despawn() {
            this.mount.destroy();
            this.bullet.destroy();
        }
    }
}

