/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.projectiles.bullet;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.volatilecode.virtual.PacketDisplayItemEntity;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.compatibility.AbstractModelEngineSupport;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.projectiles.ProjectileBullet;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletType;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Collection;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class DisplayPacketBullet
extends ProjectileBullet {
    @MythicField(name="audience", description="The audience of the message")
    protected SkillAudience audience;
    @MythicField(name="bulletMaterial", aliases={"material", "mat"}, description="The material to use for TRACKING, BLOCK, ITEM, or MYTHICITEM bullet types", defValue="STONE")
    protected Material bulletMaterial = null;
    @MythicField(name="bulletModel", aliases={"model"}, description="The custom model data of the bullet type", defValue="0")
    protected int bulletModelId = 0;
    @MythicField(name="bulletColor", description="The color of the bullet type if applicable i.e. potion color, leather armor.")
    protected String bulletColor = null;
    @MythicField(name="bulletSmall", description="Whether the bullet should use the small version or not")
    protected boolean bulletSmall = false;
    @MythicField(name="bulletEnchanted", aliases={"enchanted"}, description="Whether the item should be enchanted or not", defValue="false")
    protected boolean bulletEnchanted;
    @MythicField(name="pitch", description="The pitch rotation", defValue="0")
    final PlaceholderDouble rotationPitch;
    @MythicField(name="yaw", description="The yaw rotation", defValue="0")
    final PlaceholderDouble rotationYaw;
    @MythicField(name="roll", description="The roll rotation", defValue="0")
    final PlaceholderDouble rotationRoll;
    @MythicField(name="rotation", aliases={"rot"}, description="The rotation of the projectile, in the x,y,z format", defValue="0,0,0")
    final String rotationString;
    @MythicField(name="pitchSpeed", description="The pitch rotation speed", defValue="0")
    final PlaceholderDouble pitchSpeed;
    @MythicField(name="yaw", description="The yaw rotation speed", defValue="0")
    final PlaceholderDouble yawSpeed;
    @MythicField(name="roll", description="The roll rotation speed", defValue="0")
    final PlaceholderDouble rollSpeed;
    @MythicField(name="rotation", aliases={"rot"}, description="The rotation speed of the projectile, in the x,y,z format", defValue="0,0,0")
    final String rotationStringSpeed;
    AbstractVector rotationSpeed;
    @MythicField(name="hideFirstTick", aliases={"hft"}, description="Hides the item for the first tick", defValue="0,0,0")
    final boolean hideFirstTick;
    ItemStack bulletItem;
    @MythicField(name="bulletScale", description="The bullet's size scale")
    protected AbstractVector bulletScale;
    private PacketDisplayItemEntity.PacketDisplayItemEntityOptions options;
    private ItemFactory bulletItemStack;

    public DisplayPacketBullet(ProjectileBulletType type, Projectile projectile, MythicLineConfig config) {
        super(type, projectile, config);
        this.audience = config.getAudience("audience", "world");
        String strBulletMaterial = config.getString(new String[]{"bulletmaterial", "material", "mat"}, "STONE", new String[0]);
        this.bulletModelId = config.getInteger(new String[]{"bulletmodel", "model"}, 0);
        this.bulletColor = config.getString(new String[]{"bulletcolor"}, null, new String[0]);
        this.bulletEnchanted = config.getBoolean(new String[]{"bulletEnchanted", "enchanted"}, false);
        this.rotationPitch = config.getPlaceholderDouble(new String[]{"pitch"}, 0.0, new String[0]);
        this.rotationYaw = config.getPlaceholderDouble(new String[]{"yaw"}, 0.0, new String[0]);
        this.rotationRoll = config.getPlaceholderDouble(new String[]{"roll"}, 0.0, new String[0]);
        this.rotationString = config.getString(new String[]{"rotation", "rot"}, "0,0,0", new String[0]);
        this.pitchSpeed = config.getPlaceholderDouble(new String[]{"pitchSpeed", "ps"}, 0.0, new String[0]);
        this.yawSpeed = config.getPlaceholderDouble(new String[]{"yawSpeed", "ys"}, 0.0, new String[0]);
        this.rollSpeed = config.getPlaceholderDouble(new String[]{"rollSpeed", "rs"}, 0.0, new String[0]);
        this.rotationStringSpeed = config.getString(new String[]{"rotationSpeed", "rotSpeed", "rots"}, "0,0,0", new String[0]);
        this.hideFirstTick = config.getBoolean(new String[]{"hideFirstTick", "hft"}, false);
        String strBulletScale = config.getString(new String[]{"bulletscale", "scale"}, "0.5,0.5,0.5", new String[0]);
        try {
            String[] splitStr = strBulletScale.split(",");
            double x = Double.parseDouble(splitStr[0]);
            double y = Double.parseDouble(splitStr[1]);
            double z = Double.parseDouble(splitStr[2]);
            this.bulletScale = new AbstractVector(x, y, z);
        }
        catch (Throwable ex) {
            this.bulletScale = new AbstractVector(0.5, 0.5, 0.5);
            MythicLogger.errorMechanic(projectile, "Invalid bullet scale set: " + strBulletScale);
        }
        this.getPlugin().getSkillManager().queueAfterLoad(() -> {
            try {
                Optional<AbstractModelEngineSupport> support = this.getPlugin().getCompatibility().getModelEngine();
                if (!strBulletMaterial.contains(":") || !support.isPresent()) {
                    this.bulletMaterial = Material.valueOf((String)strBulletMaterial.toUpperCase());
                    this.bulletModelId = config.getInteger(new String[]{"bulletmodel", "model"}, 0);
                } else {
                    support.get().queuePostModelRegistration(() -> {
                        try {
                            String[] mat = strBulletMaterial.split(":");
                            AbstractModelEngineSupport.ModelConfig modelConfig = ((AbstractModelEngineSupport)support.get()).getBoneModel(mat[0], mat[1]);
                            int id = modelConfig.getId();
                            if (id == -1) {
                                throw new Exception();
                            }
                            this.bulletModelId = id;
                            this.bulletMaterial = modelConfig.getMaterial();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
                this.bulletColor = config.getString(new String[]{"bulletcolor"}, null, new String[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                MythicLogger.errorMechanicConfig(projectile, config, "Specified bullet material does not exist");
                this.bulletMaterial = Material.STONE;
            }
            this.bulletItemStack = BukkitItemStack.of(this.bulletMaterial).model(this.bulletModelId);
            if (this.bulletColor != null) {
                this.bulletItemStack.color(this.bulletColor);
            }
            if (this.bulletEnchanted) {
                this.bulletItemStack.enchant(Enchantment.VANISHING_CURSE);
            }
            if (this.hideFirstTick) {
                this.bulletItem = this.bulletItemStack.build();
                this.options = PacketDisplayItemEntity.PacketDisplayItemEntityOptions.builder().scale(this.bulletScale).build();
            } else {
                this.options = PacketDisplayItemEntity.PacketDisplayItemEntityOptions.builder().item(this.bulletItemStack.build()).scale(this.bulletScale).build();
            }
        });
    }

    @Override
    public ProjectileBullet.BulletTracker create(Projectile.ProjectileTracker projectile, AbstractEntity target) {
        return new ArmorStandBulletTracker(projectile, target);
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    AbstractVector parseRotation(String rotationString, PlaceholderDouble pPitch, PlaceholderDouble pYaw, PlaceholderDouble pRoll, SkillMetadata data) {
        double roll;
        double yaw;
        String[] split = rotationString.split(",");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (split.length == 3) {
            try {
                x = PlaceholderDouble.of(split[0]).get(data);
                y = PlaceholderDouble.of(split[1]).get(data);
                z = PlaceholderDouble.of(split[2]).get(data);
            }
            catch (NumberFormatException e) {
                MythicLogger.error("Invalid format for " + rotationString + " in " + this.getConfig().getLine());
            }
        } else {
            MythicLogger.error("Invalid format for " + rotationString + " in " + this.getConfig().getLine());
        }
        double pitch = pPitch.get(data);
        if (pitch != 0.0) {
            x = pitch;
        }
        if ((yaw = pYaw.get(data)) != 0.0) {
            y = yaw;
        }
        if ((roll = pRoll.get(data)) != 0.0) {
            z = roll;
        }
        return new AbstractVector(x, y, z);
    }

    public class ArmorStandBulletTracker
    extends ProjectileBullet.BulletTracker {
        protected PacketEntity mount;
        protected PacketDisplayItemEntity bullet;
        AbstractVector lastRotation;

        public ArmorStandBulletTracker(Projectile.ProjectileTracker projectile, AbstractEntity target) {
            super(projectile, target);
            this.lastRotation = new AbstractVector(0, 0, 0);
        }

        @Override
        public void spawn(AbstractLocation start) {
            ItemStack i = DisplayPacketBullet.this.bulletItemStack.build();
            AbstractLocation l = start.clone();
            AbstractLocation al = l.clone();
            al.setYaw(0.0f);
            al.setPitch(0.0f);
            this.mount = DisplayPacketBullet.this.getPlugin().getVolatileCodeHandler().getWorldHandler().createVirtualArmorStand(al);
            this.bullet = DisplayPacketBullet.this.getPlugin().getVolatileCodeHandler().getWorldHandler().createVirtualDisplayItemEntity(l, DisplayPacketBullet.this.options);
            AbstractLocation currentLocation = this.getProjectile().getPreviousLocation();
            AbstractVector currentVelocity = this.getProjectile().getCurrentVelocity();
            Location to = BukkitAdapter.adapt(currentLocation).clone();
            Vector delta = BukkitAdapter.adapt(currentVelocity).normalize().multiply(this.getProjectile().getVelocityMagnitude() / 7.6);
            double yaw = Math.atan2(delta.getX(), delta.getZ());
            double len = delta.getZ() / Math.cos(yaw);
            float pitch = (float)Math.atan2(delta.getY(), len);
            Location loc = to.clone().add(delta);
            float newYaw = (float)Math.toDegrees(-yaw) + 180.0f;
            float newPitch = (float)Math.toDegrees(-pitch);
            loc.setYaw(newYaw);
            loc.setPitch(newPitch);
            AbstractVector r = DisplayPacketBullet.this.parseRotation(DisplayPacketBullet.this.rotationString, DisplayPacketBullet.this.rotationPitch, DisplayPacketBullet.this.rotationYaw, DisplayPacketBullet.this.rotationRoll, this.getProjectile().getData());
            this.bullet.setRotationTransformation((float)r.getX(), (float)r.getY(), (float)r.getZ());
            Collection<AbstractPlayer> seen = DisplayPacketBullet.this.audience.get(this.getProjectile().getData(), this.getTarget());
            this.mount.spawn(seen);
            this.bullet.spawn(seen);
            this.mount.addPassenger(this.bullet);
            Schedulers.async().runLater(() -> this.mount.addPassenger(this.bullet), 1L);
        }

        @Override
        public void tick(AbstractLocation origin) {
            if (DisplayPacketBullet.this.hideFirstTick && this.getProjectile().getTimesRan() == 1) {
                this.bullet.setItem(DisplayPacketBullet.this.bulletItem);
            }
            if (this.getProjectile().getTimesRan() % 5 == 0) {
                this.mount.updateRenderedPlayers();
                this.bullet.updateRenderedPlayers();
            }
            double forwardOffset = DisplayPacketBullet.this.getProjectileMechanic().getTickInterpolation() == 0 ? DisplayPacketBullet.this.bulletForwardOffset : DisplayPacketBullet.this.bulletForwardOffset * (double)DisplayPacketBullet.this.getProjectileMechanic().getTickInterpolation();
            AbstractLocation currentLocation = this.getProjectile().getCurrentLocation().clone();
            AbstractVector currentVelocity = this.getProjectile().getCurrentVelocity().clone().multiply(forwardOffset);
            Location to = BukkitAdapter.adapt(currentLocation).add(0.0, 0.2, 0.0);
            Vector delta = BukkitAdapter.adapt(currentVelocity);
            to.add(delta);
            double yaw = Math.atan2(delta.getX(), delta.getZ());
            double len = delta.getZ() / Math.cos(yaw);
            float pitch = (float)Math.atan2(delta.getY(), len);
            Location loc = to.clone().add(delta);
            float newYaw = (float)Math.toDegrees(-yaw) + 180.0f;
            float newPitch = (float)Math.toDegrees(-pitch);
            loc.setYaw(newYaw);
            loc.setPitch(newPitch);
            DisplayPacketBullet.this.rotationSpeed = DisplayPacketBullet.this.parseRotation(DisplayPacketBullet.this.rotationStringSpeed, DisplayPacketBullet.this.pitchSpeed, DisplayPacketBullet.this.yawSpeed, DisplayPacketBullet.this.rollSpeed, this.getProjectile().getData());
            this.bullet.setRotation(newYaw, newPitch);
            if (DisplayPacketBullet.this.rotationSpeed.length() > 0.0) {
                this.lastRotation.add(DisplayPacketBullet.this.rotationSpeed);
                this.bullet.setRotationTransformation((float)this.lastRotation.getX(), (float)this.lastRotation.getY(), (float)this.lastRotation.getZ());
            }
            this.bullet.update(BukkitAdapter.adapt(loc));
            this.mount.update(BukkitAdapter.adapt(loc));
        }

        @Override
        public void despawn() {
            this.mount.destroy();
            this.bullet.destroy();
        }
    }
}

