/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.projectiles.bullet;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.projectiles.ProjectileBullet;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletType;
import io.lumine.mythic.core.utils.annotations.MythicField;
import org.bukkit.Location;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Trident;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class ArrowBullet
extends ProjectileBullet {
    @MythicField(name="arrowType", description="    The type of arrow to use if the bullet type is ARROW\n    Arrow Types:\n    - NORMAL\n    - SPECTRAL\n    - TRIDENT\n", defValue="NORMAL")
    protected ArrowType arrowType;

    public ArrowBullet(ProjectileBulletType type, Projectile projectile, MythicLineConfig config) {
        super(type, projectile, config);
        String strArrowType = config.getString(new String[]{"bulletarrowtype", "arrowtype"}, "NORMAL", new String[0]);
        try {
            this.arrowType = ArrowType.valueOf(strArrowType);
        }
        catch (Throwable ex) {
            MythicLogger.errorMechanicConfig(projectile, config, "Invalid bullet arrow type specified");
        }
    }

    @Override
    public ProjectileBullet.BulletTracker create(Projectile.ProjectileTracker projectile, AbstractEntity target) {
        return new ArrowBulletTracker(projectile, target);
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    protected static enum ArrowType {
        NORMAL,
        SPECTRAL,
        TRIDENT;

    }

    public class ArrowBulletTracker
    extends ProjectileBullet.BulletTracker {
        protected AbstractEntity bullet;

        public ArrowBulletTracker(Projectile.ProjectileTracker projectile, AbstractEntity target) {
            super(projectile, target);
            Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> this.bullet != null).filter(event -> event.getDamager() != null).filter(event -> event.getDamager().getUniqueId().equals(this.bullet.getUniqueId())).handler(event -> event.setCancelled(true)).bindWith(projectile);
        }

        @Override
        public void spawn(AbstractLocation start) {
            Location loc = BukkitAdapter.adapt(start);
            Arrow arrow = switch (ArrowBullet.this.arrowType) {
                default -> throw new IncompatibleClassChangeError();
                case ArrowType.NORMAL -> (Arrow)loc.getWorld().spawn(loc, Arrow.class);
                case ArrowType.SPECTRAL -> (SpectralArrow)loc.getWorld().spawn(loc, SpectralArrow.class);
                case ArrowType.TRIDENT -> (Trident)loc.getWorld().spawn(loc, Trident.class);
            };
            arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
            arrow.setPierceLevel(125);
            arrow.setTicksLived(Integer.MAX_VALUE);
            arrow.setInvulnerable(true);
            arrow.setGravity(false);
            this.bullet = BukkitAdapter.adapt((Entity)arrow);
            Projectile.BULLET_ENTITIES.add(this.bullet);
            ArrowBullet.this.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0);
            if (this.getProjectile().hasTerminated()) {
                this.bullet.remove();
            }
        }

        @Override
        public void tick(AbstractLocation origin) {
            AbstractVector o = this.bullet.getLocation().toVector();
            AbstractVector n = this.getProjectile().getCurrentVelocity().clone();
            AbstractVector velocity = n.subtract(o).multiply(0.25);
            this.bullet.setVelocity(velocity);
        }

        @Override
        public void despawn() {
            this.bullet.remove();
            Projectile.BULLET_ENTITIES.remove(this.bullet);
        }
    }
}

