/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.projectiles;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletType;

public abstract class ProjectileBullet {
    private final Projectile projectileMechanic;
    private final MythicLineConfig config;
    protected double bulletForwardOffset;

    public ProjectileBullet(ProjectileBulletType type, Projectile projectile, MythicLineConfig config) {
        this.projectileMechanic = projectile;
        this.config = config;
        this.bulletForwardOffset = config.getDouble(new String[]{"bulletforwardoffset", "bulletfo", "bulletoffset"}, 1.8);
    }

    public MythicBukkit getPlugin() {
        return this.projectileMechanic.getPlugin();
    }

    public abstract BulletTracker create(Projectile.ProjectileTracker var1, AbstractEntity var2);

    public abstract boolean isVirtual();

    public Projectile getProjectileMechanic() {
        return this.projectileMechanic;
    }

    public MythicLineConfig getConfig() {
        return this.config;
    }

    public double getBulletForwardOffset() {
        return this.bulletForwardOffset;
    }

    public abstract class BulletTracker {
        private final Projectile.ProjectileTracker projectile;
        private final AbstractEntity target;

        public boolean isVirtual() {
            return ProjectileBullet.this.isVirtual();
        }

        public abstract void spawn(AbstractLocation var1);

        public abstract void tick(AbstractLocation var1);

        public abstract void despawn();

        public BulletTracker(Projectile.ProjectileTracker projectile, AbstractEntity target) {
            this.projectile = projectile;
            this.target = target;
        }

        public Projectile.ProjectileTracker getProjectile() {
            return this.projectile;
        }

        public AbstractEntity getTarget() {
            return this.target;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulletTracker)) {
                return false;
            }
            BulletTracker other = (BulletTracker)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Projectile.ProjectileTracker this$projectile = this.getProjectile();
            Projectile.ProjectileTracker other$projectile = other.getProjectile();
            if (this$projectile == null ? other$projectile != null : !this$projectile.equals(other$projectile)) {
                return false;
            }
            AbstractEntity this$target = this.getTarget();
            AbstractEntity other$target = other.getTarget();
            return !(this$target == null ? other$target != null : !this$target.equals(other$target));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BulletTracker;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Projectile.ProjectileTracker $projectile = this.getProjectile();
            result = result * 59 + ($projectile == null ? 43 : $projectile.hashCode());
            AbstractEntity $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            return result;
        }

        public String toString() {
            return "ProjectileBullet.BulletTracker(projectile=" + this.getProjectile() + ", target=" + this.getTarget() + ")";
        }
    }
}

