/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="velocity", description="Sets the velocity on the target entity")
public class VelocityMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderFloat velocityX;
    protected PlaceholderFloat velocityY;
    protected PlaceholderFloat velocityZ;
    protected VelocityMode mode;
    protected boolean relative;

    public VelocityMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.velocityX = mlc.getPlaceholderFloat(new String[]{"velocityx", "vx", "x"}, 1.0f, new String[0]);
        this.velocityY = mlc.getPlaceholderFloat(new String[]{"velocityy", "vy", "y"}, 1.0f, new String[0]);
        this.velocityZ = mlc.getPlaceholderFloat(new String[]{"velocityz", "vz", "z"}, 1.0f, new String[0]);
        this.relative = mlc.getBoolean(new String[]{"relative", "r"}, false);
        String strMode = mlc.getString(new String[]{"mode", "m"}, "SET", new String[0]);
        try {
            this.mode = VelocityMode.valueOf(strMode);
        }
        catch (IllegalArgumentException e) {
            this.mode = VelocityMode.SET;
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        AbstractVector v = target.getVelocity();
        AbstractVector velocityChange = new AbstractVector(this.velocityX.get(data, target), this.velocityY.get(data, target), this.velocityZ.get(data, target));
        if (this.relative) {
            velocityChange = target.getLocation().getDirection().multiply(velocityChange);
        }
        switch (this.mode) {
            case SET: {
                v = velocityChange;
                break;
            }
            case ADD: {
                v.add(velocityChange);
                break;
            }
            case MULTIPLY: {
                v.multiply(velocityChange);
                break;
            }
            case REMOVE: {
                v.subtract(velocityChange);
                break;
            }
            case DIVIDE: {
                v.divide(velocityChange);
                break;
            }
            default: {
                return SkillResult.INVALID_CONFIG;
            }
        }
        if (Double.isNaN(v.getX())) {
            v.setX(0);
        }
        if (Double.isNaN(v.getY())) {
            v.setY(0);
        }
        if (Double.isNaN(v.getZ())) {
            v.setZ(0);
        }
        target.setVelocity(v);
        return SkillResult.SUCCESS;
    }

    static enum VelocityMode {
        SET,
        ADD,
        MULTIPLY,
        REMOVE,
        DIVIDE;

    }
}

