/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableMechanic;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import java.io.File;
import net.objecthunter.exp4j.ExpressionBuilder;

@MythicMechanic(author="Ashijin", name="variableSet", aliases={"setVariable", "setVar"}, description="Sets a variable on the target entity")
public class VariableSetMechanic
extends VariableMechanic
implements ITargetedEntitySkill {
    protected PlaceholderString value;
    protected VariableType type;

    public VariableSetMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        try {
            this.value = PlaceholderString.of(mlc.getString(new String[]{"value", "val", "v"}, null, new String[0]));
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Variable value must be set.");
            return;
        }
        String strType = mlc.getString(new String[]{"type", "t"}, VariableType.INTEGER.toString(), new String[0]);
        try {
            this.type = VariableType.valueOf(strType.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "'" + strType + "' is not a valid variable type.");
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Variable var;
        VariableRegistry variables = this.getVariableManager().getRegistry(this.scope, data, target);
        if (variables == null) {
            MythicLogger.errorMechanicConfig(this, this.config, "Failed to get variable registry");
            return SkillResult.INVALID_CONFIG;
        }
        if (this.type == VariableType.INTEGER || this.type == VariableType.FLOAT) {
            String eq = this.value.get(data, target);
            double amount = new ExpressionBuilder(eq).operator(Operators.operators).functions(Functions.functions).build().evaluate();
            var = Variable.ofType(this.type, (Object)amount, this.duration);
        } else {
            var = Variable.ofType(this.type, (Object)this.value.get(data, target), this.duration);
        }
        variables.put(this.key, var);
        return SkillResult.SUCCESS;
    }
}

