/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IMetaSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.MetaSkill;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@MythicMechanic(author="Seyarada", name="switch", description="Acts as a switch/case")
public class SwitchMechanic
extends SkillMechanic
implements IMetaSkill {
    final HashMap<String, MetaSkill> caseSkills = new HashMap();
    final HashMap<String, SkillCondition> caseConditions = new HashMap();
    Skill defaultSkill;
    boolean uniqueResult;

    public SwitchMechanic(SkillExecutor manager, File file, String mlcLine, MythicLineConfig mlc) {
        super(manager, file, mlcLine, mlc);
        this.uniqueResult = mlc.getBoolean(new String[]{"uniqueresult", "unique", "first"}, true);
        String baseCondition = mlc.getString("condition");
        List<String> entries = Arrays.stream(mlc.getString("cases").split("case")).skip(1L).map(String::trim).collect(Collectors.toList());
        entries.forEach(c -> {
            int i = c.indexOf("=");
            String caseStr = c.substring(0, i);
            boolean isDefault = caseStr.equalsIgnoreCase("default");
            String caseSkill = c.substring(i + 1);
            MetaSkill skill = (MetaSkill)this.getSkillFrom(caseSkill);
            if (isDefault) {
                this.defaultSkill = skill;
            } else if (skill != null) {
                String caseCondition = baseCondition.replace("<case>", caseStr);
                SkillCondition condition = ((MythicBukkit)this.getPlugin()).getSkillManager().getCondition(caseCondition);
                if (!(condition instanceof InvalidCondition)) {
                    this.caseSkills.put(caseStr, skill);
                    this.caseConditions.put(caseStr, condition);
                }
            }
        });
    }

    @Override
    public SkillResult cast(SkillMetadata meta) {
        boolean hasExecuted = false;
        for (Map.Entry<String, SkillCondition> entry : this.caseConditions.entrySet()) {
            if (this.uniqueResult && hasExecuted) break;
            SkillMetadata metaClone = meta.deepClone();
            if (!entry.getValue().evaluateTargets(metaClone)) continue;
            this.caseSkills.get(entry.getKey()).execute(metaClone);
            hasExecuted = true;
        }
        if (!hasExecuted && this.defaultSkill != null) {
            this.defaultSkill.execute(meta);
        }
        return SkillResult.SUCCESS;
    }

    Skill getSkillFrom(String str) {
        String mySkill = str;
        if (str.contains("[")) {
            int first = str.indexOf("[");
            String skillString = str.substring(first);
            int sep = skillString.lastIndexOf("]");
            mySkill = skillString.substring(0, sep + 1);
        }
        return this.getManager().getSkill(this.file, this, mySkill).orElse(null);
    }
}

