/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;

@MythicMechanic(author="Ashijin", version="4.8", name="stun", description="Applies an aura that stuns the target entity")
public class StunMechanic
extends Aura
implements ITargetedEntitySkill {
    private boolean stopAI;
    private boolean stopGravity;
    private boolean freezeFacing;
    private boolean knockbackResist;

    public StunMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.stopAI = mlc.getBoolean(new String[]{"stopai", "ai"}, false);
        this.stopGravity = mlc.getBoolean(new String[]{"gravity", "g"}, false);
        this.freezeFacing = mlc.getBoolean(new String[]{"facing", "face", "f"}, false);
        this.knockbackResist = mlc.getBoolean(new String[]{"noknockback", "nokb", "kb"}, false);
        this.interval = PlaceholderInt.of("1");
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new StunMechanicTracker(target, data);
        return SkillResult.SUCCESS;
    }

    protected class StunMechanicTracker
    extends Aura.AuraTracker {
        private double x;
        private double y;
        private double z;
        private float pitch;
        private float yaw;
        private boolean hadAI;
        private boolean hadGravity;
        private double kbRes;

        public StunMechanicTracker(AbstractEntity target, SkillMetadata data) {
            super(target, data);
            this.hadAI = false;
            this.hadGravity = false;
            this.x = target.getLocation().getX();
            this.y = target.getLocation().getY();
            this.z = target.getLocation().getZ();
            this.pitch = target.getLocation().getPitch();
            this.yaw = target.getLocation().getYaw();
            this.start();
        }

        @Override
        public void auraStart() {
            AttributeInstance attr;
            if (StunMechanic.this.stopAI && ((AbstractEntity)this.entity.get()).hasAI()) {
                this.hadAI = true;
                ((AbstractEntity)this.entity.get()).setAI(false);
            }
            if (StunMechanic.this.stopGravity && ((AbstractEntity)this.entity.get()).hasGravity()) {
                this.hadGravity = true;
                ((AbstractEntity)this.entity.get()).setGravity(false);
            }
            if (StunMechanic.this.knockbackResist && ((AbstractEntity)this.entity.get()).isLiving() && (attr = ((LivingEntity)((AbstractEntity)this.entity.get()).getBukkitEntity()).getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE)) != null) {
                this.kbRes = attr.getBaseValue();
                attr.setBaseValue(10.0);
            }
            this.executeAuraSkill(StunMechanic.this.onStartSkill, this.skillMetadata);
        }

        @Override
        public void auraTick() {
            if (!StunMechanic.this.freezeFacing) {
                this.pitch = ((AbstractEntity)this.entity.get()).getLocation().getPitch();
                this.yaw = ((AbstractEntity)this.entity.get()).getLocation().getYaw();
            }
            ((MythicBukkit)StunMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setLocation((AbstractEntity)this.entity.get(), this.x, this.y, this.z, this.yaw, this.pitch, StunMechanic.this.freezeFacing, StunMechanic.this.stopGravity);
        }

        @Override
        public void auraStop() {
            AttributeInstance attr;
            if (StunMechanic.this.stopAI && this.hadAI) {
                ((AbstractEntity)this.entity.get()).setAI(true);
            }
            if (StunMechanic.this.stopGravity && this.hadGravity) {
                ((AbstractEntity)this.entity.get()).setGravity(true);
            }
            if (StunMechanic.this.knockbackResist && ((AbstractEntity)this.entity.get()).isLiving() && (attr = ((LivingEntity)((AbstractEntity)this.entity.get()).getBukkitEntity()).getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE)) != null) {
                attr.setBaseValue(this.kbRes);
            }
            this.executeAuraSkill(StunMechanic.this.onEndSkill, this.skillMetadata);
        }
    }
}

