/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.SoundCategory;

@MythicMechanic(author="Phil", name="effect:stopsound", aliases={"stopsound", "e:ss", "ss"}, description="Stops a sound from playing for the targeted entity")
public class StopSoundEffect
extends SkillMechanic
implements ITargetedEntitySkill {
    private PlaceholderString sound;
    private SoundCategory soundCategory;

    public StopSoundEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.sound = mlc.getPlaceholderString(new String[]{"sound", "s"}, "entity.zombie.attack_iron_door", new String[0]);
        String soundCategoryString = mlc.getString(new String[]{"soundcategory", "source", "sc", "category"}, null, new String[0]);
        if (soundCategoryString != null) {
            for (SoundCategory sc : SoundCategory.values()) {
                if (!soundCategoryString.toUpperCase().equals(sc.toString())) continue;
                this.soundCategory = sc;
                break;
            }
            if (this.soundCategory == null) {
                MythicLogger.errorMechanicConfig(this, mlc, "Invalid SoundCategory specified");
            }
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        BukkitAdapter.adapt(target.asPlayer()).stopSound(this.sound.get(data, target), this.soundCategory == null ? SoundCategory.MASTER : this.soundCategory);
        return SkillResult.SUCCESS;
    }
}

