/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.holograms.types.SpeechBubble;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="speak", aliases={"speech"}, description="Makes the caster speak using chat and speech bubbles")
public class SpeakMechanic
extends Aura
implements INoTargetSkill,
ITargetedEntitySkill {
    protected PlaceholderString chatMessage;
    protected PlaceholderString bubbleMessage;
    protected float offset;
    protected int radius;
    protected int maxLineLength;
    protected boolean animateWords;
    protected boolean animateLetters;
    protected boolean sendChatMessage;
    protected PlaceholderString linePrefix;

    public SpeakMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.target_creative = true;
        this.auraName = Optional.of(PlaceholderString.of("#speaking"));
        this.charges = PlaceholderInt.of("1");
        this.maxStacks = PlaceholderInt.of("1");
        this.mergeSameCaster = false;
        this.overwriteCaster = true;
        this.refreshDuration = false;
        this.offset = mlc.getFloat(new String[]{"offset", "o"}, 0.4f);
        this.radius = mlc.getInteger(new String[]{"radius", "r"}, 12);
        this.maxLineLength = mlc.getInteger(new String[]{"maxlinelength", "linelength", "ll", "mll", "ml"}, 22);
        this.linePrefix = mlc.getPlaceholderString(new String[]{"lineprefix", "lp"}, "&f", new String[0]);
        this.sendChatMessage = mlc.getBoolean(new String[]{"sendchatmessage", "chatmessage", "chat"}, true);
        PlaceholderString message = mlc.getPlaceholderString(new String[]{"message", "msg", "m"}, null, new String[0]);
        String chatPrefix = mlc.getString(new String[]{"chatprefix", "cp"}, "<caster.name>&f<&co> ", new String[0]);
        if (message == null) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'message' attribute is required.");
            this.chatMessage = PlaceholderString.of("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
            this.bubbleMessage = PlaceholderString.of("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded Speak mechanic with message {0}", message.toString());
            this.chatMessage = PlaceholderString.of(chatPrefix + message);
            this.bubbleMessage = message;
        }
        this.duration = mlc.getPlaceholderInteger(new String[]{"ticks", "t", "duration", "d", "time", "t"}, message.toString().length() * 4, new String[0]);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        if (!((MythicBukkit)this.getPlugin()).getHologramManager().isActive()) {
            this.sendChatSpeech(data, this.chatMessage.get(data));
            return SkillResult.MISSING_COMPATIBILITY;
        }
        new SpeechTracker(data);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!((MythicBukkit)this.getPlugin()).getHologramManager().isActive()) {
            this.sendChatSpeech(data, this.chatMessage.get(data, target));
            return SkillResult.MISSING_COMPATIBILITY;
        }
        new SpeechTracker(target, data);
        return SkillResult.SUCCESS;
    }

    public void sendChatSpeech(SkillMetadata data, String message) {
        if (!this.sendChatMessage) {
            return;
        }
        for (AbstractPlayer p : MythicBukkit.inst().getEntityManager().getPlayers(data.getCaster().getEntity().getWorld())) {
            if (!p.getWorld().equals(data.getCaster().getEntity().getWorld()) || !(data.getCaster().getEntity().getLocation().distanceSquared(p.getLocation()) < Math.pow(this.radius, 2.0))) continue;
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Sending speech to {0}: {1}", p.getName(), message);
            p.sendMessage(message);
        }
    }

    public class SpeechTracker
    extends Aura.AuraTracker {
        private SpeechBubble bubble;
        private String speech;

        public SpeechTracker(SkillMetadata data) {
            super(data);
            this.speech = SpeakMechanic.this.bubbleMessage.get(data);
            this.speech = Text.colorizeLegacy(this.speech);
            if (this.start()) {
                SpeakMechanic.this.sendChatSpeech(this.skillMetadata, SpeakMechanic.this.chatMessage.get(data));
            }
        }

        public SpeechTracker(AbstractEntity target, SkillMetadata data) {
            super(data.getCaster(), target, data);
            this.speech = SpeakMechanic.this.bubbleMessage.get(data, target);
            if (this.start()) {
                SpeakMechanic.this.sendChatSpeech(this.skillMetadata, SpeakMechanic.this.chatMessage.get(data, target));
            }
        }

        @Override
        public void auraStart() {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Creating speech bubble...", new Object[0]);
            this.bubble = ((MythicBukkit)SpeakMechanic.this.getPlugin()).getHologramManager().createSpeechBubble(this.skillMetadata.getCaster());
            this.bubble.setYOffset(SpeakMechanic.this.offset);
            this.bubble.setLineLength(SpeakMechanic.this.maxLineLength);
            this.bubble.setLinePrefix(SpeakMechanic.this.linePrefix.get());
            this.bubble.setText(this.speech);
            this.executeAuraSkill(SpeakMechanic.this.onStartSkill, this.skillMetadata);
        }

        @Override
        public void auraTick() {
            this.executeAuraSkill(SpeakMechanic.this.onTickSkill, this.skillMetadata);
        }

        @Override
        public void auraStop() {
            this.bubble.terminate();
            if (SpeakMechanic.this.doEndSkillOnTerminate) {
                this.executeAuraSkill(SpeakMechanic.this.onEndSkill, this.skillMetadata);
            }
        }
    }
}

