/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="shieldPercent", description="Shields the target entity for a percent of their health")
public class ShieldPercentMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected float multiplier = 0.1f;
    protected float maxShield = 0.1f;

    public ShieldPercentMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.multiplier = (float)mlc.getDouble(new String[]{"multiplier", "m"}, 0.1);
        this.maxShield = mlc.getFloat(new String[]{"maxabsorb", "maxshield", "ma", "ms"}, this.multiplier);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead()) {
            return SkillResult.INVALID_TARGET;
        }
        double shield = target.getMaxHealth() * (double)this.multiplier;
        double max = target.getMaxHealth() * (double)this.maxShield;
        double absorb = (double)MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().getEntityAbsorptionHearts(target) + shield;
        if (absorb < max) {
            MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().setEntityAbsorptionHearts(target, (float)absorb);
        }
        return SkillResult.SUCCESS;
    }
}

