/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="setlevel", aliases={"modifylevel"}, description="Modifies the castering mob's level")
public class SetLevelMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected SetLevelAction action;
    protected PlaceholderDouble level;

    public SetLevelMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        String strAction = mlc.getString(new String[]{"action", "a"}, "SET", new String[0]);
        try {
            this.action = SetLevelAction.valueOf(strAction.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.level = PlaceholderDouble.of(mlc.getString(new String[]{"level", "l"}, "1", new String[0]));
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        if (!(data.getCaster() instanceof ActiveMob)) {
            return SkillResult.INVALID_TARGET;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        double level = this.level.get(data);
        if (this.action == SetLevelAction.SET) {
            am.setLevel(level);
        } else if (this.action == SetLevelAction.ADD) {
            am.setLevel(am.getLevel() + level);
        } else if (this.action == SetLevelAction.SUBTRACT) {
            am.setLevel(am.getLevel() - level);
        } else if (this.action == SetLevelAction.MULTIPLY) {
            am.setLevel(am.getLevel() * level);
        } else if (this.action == SetLevelAction.DIVIDE) {
            am.setLevel(am.getLevel() / level);
        }
        return SkillResult.SUCCESS;
    }

    protected static enum SetLevelAction {
        SET,
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE;

    }
}

