/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.mechanics.MissileMechanic;
import io.lumine.mythic.core.skills.mechanics.ProjectileMechanic;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="projectilevelocity", aliases={"pvelocity"}, description="Sets the velocity on the calling projectile")
public class ProjectileVelocityMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected PlaceholderFloat velocityX;
    protected PlaceholderFloat velocityY;
    protected PlaceholderFloat velocityZ;
    protected VelocityMode mode;
    protected boolean relative;

    public ProjectileVelocityMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.velocityX = mlc.getPlaceholderFloat(new String[]{"velocityx", "vx", "x"}, 1.0f, new String[0]);
        this.velocityY = mlc.getPlaceholderFloat(new String[]{"velocityy", "vy", "y"}, 1.0f, new String[0]);
        this.velocityZ = mlc.getPlaceholderFloat(new String[]{"velocityz", "vz", "z"}, 1.0f, new String[0]);
        this.relative = mlc.getBoolean(new String[]{"relative", "r"}, true);
        String strMode = mlc.getString(new String[]{"mode", "m"}, "SET", new String[0]);
        try {
            this.mode = VelocityMode.valueOf(strMode);
        }
        catch (IllegalArgumentException e) {
            this.mode = VelocityMode.SET;
        }
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        IParentSkill iParentSkill = data.getCallingEvent();
        if (iParentSkill instanceof ProjectileMechanic.ProjectileMechanicTracker) {
            ProjectileMechanic.ProjectileMechanicTracker projectileTracker = (ProjectileMechanic.ProjectileMechanicTracker)iParentSkill;
            this.applyVelocityChange(data, projectileTracker);
        } else {
            iParentSkill = data.getCallingEvent();
            if (iParentSkill instanceof MissileMechanic.MissileTracker) {
                MissileMechanic.MissileTracker missileTracker = (MissileMechanic.MissileTracker)iParentSkill;
                this.applyVelocityChange(data, missileTracker);
            }
        }
        return SkillResult.SUCCESS;
    }

    public void applyVelocityChange(SkillMetadata data, Projectile.ProjectileTracker projectile) {
        AbstractVector v = projectile.getCurrentVelocity();
        AbstractVector velocityChange = new AbstractVector(this.velocityX.get(data), this.velocityY.get(data), this.velocityZ.get(data));
        if (this.relative) {
            AbstractVector up = new AbstractVector(0, 1, 0);
            AbstractVector forward = v.normalize();
            AbstractVector right = up.crossProduct(forward);
            up = forward.crossProduct(right);
            AbstractVector localV = new AbstractVector(v.dot(right), v.dot(up), v.dot(forward));
            switch (this.mode) {
                case SET: {
                    localV = velocityChange;
                    break;
                }
                case ADD: {
                    localV = localV.add(velocityChange);
                    break;
                }
                case MULTIPLY: {
                    localV = localV.multiply(velocityChange);
                    break;
                }
                case REMOVE: {
                    localV = localV.subtract(velocityChange);
                    break;
                }
                case DIVIDE: {
                    localV = localV.divide(velocityChange);
                    break;
                }
            }
            v = right.multiply(localV.getX()).add(up.multiply(localV.getY())).add(forward.multiply(localV.getZ()));
            if (Double.isNaN(v.getX())) {
                v.setX(0);
            }
            if (Double.isNaN(v.getY())) {
                v.setY(0);
            }
            if (Double.isNaN(v.getZ())) {
                v.setZ(0);
            }
            projectile.setCurrentVelocity(v);
        } else {
            switch (this.mode) {
                case SET: {
                    v = velocityChange;
                    break;
                }
                case ADD: {
                    v = v.add(velocityChange);
                    break;
                }
                case MULTIPLY: {
                    v = v.multiply(velocityChange);
                    break;
                }
                case REMOVE: {
                    v = v.subtract(velocityChange);
                    break;
                }
                case DIVIDE: {
                    v = v.divide(velocityChange);
                    break;
                }
            }
            if (Double.isNaN(v.getX())) {
                v.setX(0);
            }
            if (Double.isNaN(v.getY())) {
                v.setY(0);
            }
            if (Double.isNaN(v.getZ())) {
                v.setZ(0);
            }
            projectile.setCurrentVelocity(v);
        }
    }

    static enum VelocityMode {
        SET,
        ADD,
        MULTIPLY,
        REMOVE,
        DIVIDE;

    }
}

