/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@MythicMechanic(author="Ashijin", name="potion", description="Applies a potion effect to the target entity")
public class PotionMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderString effect;
    protected PlaceholderInt duration;
    protected PlaceholderInt lvl;
    protected boolean overwrite;
    protected boolean ambientParticles;
    protected boolean hasParticles;
    protected boolean hasIcon;

    public PotionMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.effect = mlc.getPlaceholderString(new String[]{"type", "effect", "t"}, "SLOW", new String[0]);
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "d"}, 100, new String[0]);
        this.lvl = mlc.getPlaceholderInteger(new String[]{"level", "lvl", "l"}, 1, new String[0]);
        this.overwrite = mlc.getBoolean(new String[]{"overwrite", "ow", "override", "or", "force"}, false);
        this.ambientParticles = mlc.getBoolean(new String[]{"ambientparticles", "ambient", "a"}, false);
        this.hasParticles = mlc.getBoolean(new String[]{"hasparticles", "particles", "p"}, true);
        this.hasIcon = mlc.getBoolean(new String[]{"hasicon", "icon", "i"}, true);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        PotionEffect effect;
        String potion = this.effect.get(data, target);
        int duration = this.duration.get(data, target);
        int lvl = this.lvl.get(data, target);
        PotionEffectType type = PotionEffectType.getByName((String)potion);
        try {
            effect = ServerVersion.isAfterOrEq(MinecraftVersions.v1_15) ? new PotionEffect(type, duration, lvl, this.ambientParticles, this.hasParticles, this.hasIcon) : new PotionEffect(type, duration, lvl);
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, this.config, "The 'type' attribute must be a valid potion type.");
            return SkillResult.INVALID_CONFIG;
        }
        if (this.overwrite) {
            LivingEntity l = (LivingEntity)target.getBukkitEntity();
            l.removePotionEffect(type);
            l.addPotionEffect(effect);
        } else {
            target.addPotionEffect(effect);
        }
        return SkillResult.SUCCESS;
    }
}

