/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;

@MythicMechanic(author="Ashijin", name="potionclear", aliases={"clearpotions", "clearpotion"}, description="Clears all potion effects on the target entity")
public class PotionClearMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    public PotionClearMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        LivingEntity l = (LivingEntity)target.getBukkitEntity();
        for (PotionEffect pe : l.getActivePotionEffects()) {
            l.removePotionEffect(pe.getType());
        }
        return SkillResult.SUCCESS;
    }
}

