/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.skills.ParticleMaker;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ParticleEffect;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Collection;

@MythicMechanic(author="Ashijin", name="effect:particlering", aliases={"particlering", "e:pr", "pr"})
public class ParticleRingEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private PlaceholderFloat radius;
    private int points;
    private float inc;

    public ParticleRingEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.points = mlc.getInteger(new String[]{"points", "pts"}, 8);
        this.radius = mlc.getPlaceholderFloat(new String[]{"radius", "r"}, 10.0f, new String[0]);
        if (this.points <= 0) {
            this.points = 1;
        }
        this.inc = 360.0f / (float)this.points;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, null);
        if (this.fromOrigin) {
            this.playParticleRingEffect(data, data.getOrigin(), audience);
        } else {
            this.playParticleRingEffect(data, target, audience);
        }
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, target);
        this.playParticleRingEffect(data, target.getLocation(), audience);
        return SkillResult.SUCCESS;
    }

    protected void playParticleRingEffect(SkillMetadata data, AbstractLocation t2, Collection<AbstractPlayer> audience) {
        AbstractLocation target = t2;
        if (target == null) {
            return;
        }
        double bx = target.getX();
        double y = target.getY() + (double)this.yOffset.get(data);
        double bz = target.getZ();
        AbstractWorld w = target.getWorld();
        for (double i = 0.0; i < 360.0; i += (double)this.inc) {
            double angle = i * Math.PI / 180.0;
            double x = bx + (double)this.radius.get(data) * Math.cos(angle);
            double z = bz + (double)this.radius.get(data) * Math.sin(angle);
            AbstractLocation l = new AbstractLocation(w, x, y, z);
            if (this.directional) {
                this.playDirectionalParticleEffect(data, l, target, l, audience);
                continue;
            }
            this.playParticleEffect(data, l, audience);
        }
    }

    protected void playDirectionalParticleEffect(SkillMetadata data, AbstractLocation origin, AbstractLocation target, AbstractLocation spawn, Collection<AbstractPlayer> audience) {
        AbstractVector direction = this.directionReversed ? origin.toVector().subtract(target.clone().toVector()).normalize() : target.toVector().subtract(origin.clone().toVector()).normalize();
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            if (this.particleData == null) {
                this.particle.sendDirectional(audience, origin, this.pSpeed.get(data), this.amount.get(data), this.xSpread.get(data), this.vSpread.get(data), this.zSpread.get(data), direction);
            }
        } else {
            int amount = this.amount.get(data) / this.points;
            for (int i = 0; i < amount; ++i) {
                AbstractLocation ln = spawn.clone().add((double)(0.0f - this.xSpread.get(data)) + Numbers.randomDouble() * (double)this.xSpread.get(data) * 2.0, (double)this.vSpread.get(data) + Numbers.randomDouble() * (double)this.vSpread.get(data) * 2.0, (double)(0.0f - this.zSpread.get(data)) + Numbers.randomDouble() * (double)this.zSpread.get(data) * 2.0);
                new ParticleMaker.ParticlePacket(this.strParticle, direction, this.pSpeed.get(data), 1, true).send(ln, this.viewDistance);
            }
        }
    }
}

