/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ParticleEffect;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Collection;

@MythicMechanic(author="Ashijin", name="effect:particlelinehelix", aliases={"particlelinehelix", "particlehelixline"})
public class ParticleLineHelixEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float distanceBetween;
    protected float startYOffset;
    protected float targetYOffset;
    protected boolean fromOrigin;
    protected double helixLength;
    protected double helixRadius;
    protected double helixRotation;
    protected double maxDistance;

    public ParticleLineHelixEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.startYOffset = mlc.getFloat(new String[]{"startyoffset", "syo", "ystartoffset", "ys"}, 0.0f);
        this.targetYOffset = mlc.getFloat(new String[]{"targetyoffset", "tyo", "ytargetoffset", "yt"}, 0.0f);
        this.distanceBetween = mlc.getFloat(new String[]{"distancebetween", "db"}, 1.0f);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.helixLength = mlc.getDouble(new String[]{"helixlength", "hl"}, 2.0);
        this.helixRadius = mlc.getDouble(new String[]{"helixradius", "hr"}, 1.0);
        this.helixRotation = mlc.getDouble(new String[]{"helixrotation", "rot"}, 0.0);
        this.maxDistance = mlc.getDouble(new String[]{"maxdistance", "md"}, 256.0);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, null);
        this.playParticleLineEffect(data, target, audience);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, target);
        this.playParticleLineEffect(data, target.getLocation(), audience);
        return SkillResult.SUCCESS;
    }

    protected void playParticleLineEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractPlayer> audience) {
        double distance;
        SkillCaster am = data.getCaster();
        AbstractLocation origin = data.getOrigin();
        AbstractLocation targetLocation = target.clone().add(0.0, this.targetYOffset, 0.0);
        AbstractLocation startLocation = this.fromOrigin ? origin.add(0.0, this.startYOffset, 0.0) : (this.useEyeLocation ? am.getEntity().getEyeLocation() : am.getEntity().getLocation().add(0.0, this.startYOffset, 0.0));
        if (this.setYaw) {
            startLocation.setYaw(this.yaw);
        }
        if (this.setPitch) {
            startLocation.setPitch(this.pitch);
        }
        if (this.startForwardOffset != 0.0f) {
            startLocation = MythicUtil.move(startLocation, this.startForwardOffset, 0.0, 0.0);
        }
        if (this.startSideOffset != 0.0f) {
            startLocation = MythicUtil.move(startLocation, 0.0, 0.0, this.startSideOffset);
        }
        if ((distance = startLocation.distance(targetLocation)) > this.maxDistance) {
            distance = this.maxDistance;
        }
        AbstractVector direction = targetLocation.toVector().subtract(startLocation.toVector()).normalize();
        double totalRevolutions = distance / this.helixLength;
        double particlesPerRevolution = this.helixLength / (double)this.distanceBetween;
        int totalParticles = (int)Math.round(particlesPerRevolution * totalRevolutions);
        double step = distance / (double)totalParticles;
        AbstractVector up = Math.abs(direction.getY()) < 0.99 ? new AbstractVector(0, 1, 0) : new AbstractVector(1, 0, 0);
        AbstractVector side = direction.crossProduct(up).normalize();
        double helixRotationRadians = Math.toRadians(this.helixRotation);
        for (int i = 0; i < totalParticles; ++i) {
            double angle = Math.PI * 2 * (double)i / particlesPerRevolution + helixRotationRadians;
            double xOffset = this.helixRadius * Math.cos(angle);
            double zOffset = this.helixRadius * Math.sin(angle);
            AbstractVector offset = side.clone().multiply(xOffset).add(up.clone().multiply(zOffset));
            AbstractLocation particleLocation = startLocation.clone().add(direction.clone().multiply(step * (double)i)).add(offset);
            this.playParticleEffect(data, particleLocation, audience);
        }
    }
}

