/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.skills.ParticleMaker;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ParticleEffect;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Collection;

@MythicMechanic(author="Ashijin", name="effect:particleline", aliases={"e:pl", "pl", "particleline"})
public class ParticleLineEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float distanceBetween;
    protected float startYOffset;
    protected float targetYOffset;
    protected boolean fromOrigin;
    protected boolean zigZag;
    protected int zigZags = 10;
    protected double zigZagOffset;
    protected double maxDistance;

    public ParticleLineEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.startYOffset = mlc.getFloat(new String[]{"startyoffset", "syo", "ystartoffset", "ys"}, 0.0f);
        this.targetYOffset = mlc.getFloat(new String[]{"targetyoffset", "tyo", "ytargetoffset", "yt"}, 0.0f);
        this.distanceBetween = mlc.getFloat(new String[]{"distancebetween", "db"}, 0.25f);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.zigZag = mlc.getBoolean(new String[]{"zigzag", "zz"}, false);
        this.zigZags = mlc.getInteger(new String[]{"zigzags", "zzs"}, 10);
        this.zigZagOffset = mlc.getDouble(new String[]{"zigzagoffset", "zzo"}, 0.2);
        this.maxDistance = mlc.getDouble(new String[]{"maxdistance", "md"}, 256.0);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, null);
        this.playParticleLineEffect(data, target, audience);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, target);
        this.playParticleLineEffect(data, target.getLocation(), audience);
        return SkillResult.SUCCESS;
    }

    protected void playParticleLineEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractPlayer> audience) {
        int c;
        double distance;
        SkillCaster am = data.getCaster();
        AbstractLocation origin = data.getOrigin();
        AbstractLocation targetLocation = target.clone().add(0.0, this.targetYOffset, 0.0);
        AbstractLocation startLocation = this.fromOrigin ? origin.add(0.0, this.startYOffset, 0.0) : (this.useEyeLocation ? am.getEntity().getEyeLocation() : am.getEntity().getLocation().add(0.0, this.startYOffset, 0.0));
        if (this.setYaw) {
            startLocation.setYaw(this.yaw);
        }
        if (this.setPitch) {
            startLocation.setPitch(this.pitch);
        }
        if (this.startForwardOffset != 0.0f) {
            startLocation = MythicUtil.move(startLocation, this.startForwardOffset, 0.0, 0.0);
        }
        if (this.startSideOffset != 0.0f) {
            startLocation = MythicUtil.move(startLocation, 0.0, 0.0, this.startSideOffset);
        }
        if ((distance = startLocation.distance(targetLocation)) > this.maxDistance) {
            distance = this.maxDistance;
        }
        if ((c = (int)Math.ceil(distance / (double)this.distanceBetween) - 1) <= 0) {
            return;
        }
        AbstractVector v = targetLocation.toVector().subtract(startLocation.toVector()).normalize().multiply(this.distanceBetween);
        AbstractLocation l2 = startLocation.clone().add(0.0, this.yOffset.get(data), 0.0);
        boolean zag = false;
        AbstractVector zigZagOffset = null;
        if (this.zigZag) {
            double oX = -(this.zigZagOffset / 2.0) + this.zigZagOffset * Numbers.randomDouble();
            double oY = -(this.zigZagOffset / 2.0) + this.zigZagOffset * Numbers.randomDouble();
            double oZ = -(this.zigZagOffset / 2.0) + this.zigZagOffset * Numbers.randomDouble();
            zigZagOffset = new AbstractVector(oX, oY, oZ);
        }
        int step = 0;
        int amount = c / this.zigZags;
        for (int i = 0; i < c; ++i) {
            if (this.zigZag) {
                if (zag) {
                    l2.add(zigZagOffset);
                } else {
                    l2.subtract(zigZagOffset);
                }
                if (step >= amount) {
                    zag = !zag;
                    step = 0;
                }
                ++step;
            }
            l2.add(v);
            if (this.directional) {
                this.playDirectionalParticleEffect(data, startLocation, targetLocation, l2, audience);
                continue;
            }
            this.playParticleEffect(data, l2, audience);
        }
    }

    protected void playDirectionalParticleEffect(SkillMetadata data, AbstractLocation origin, AbstractLocation target, AbstractLocation spawn, Collection<AbstractPlayer> audience) {
        AbstractVector direction = this.directionReversed ? origin.toVector().subtract(target.clone().toVector()).normalize() : target.toVector().subtract(origin.clone().toVector()).normalize();
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            if (this.particleData == null) {
                this.particle.sendDirectional(audience, origin, this.pSpeed.get(data), this.amount.get(data), this.xSpread.get(data), this.vSpread.get(data), this.zSpread.get(data), direction);
            }
        } else {
            int amount = this.amount.get(data);
            for (int i = 0; i < amount; ++i) {
                AbstractLocation ln = spawn.clone().add((double)(0.0f - this.xSpread.get(data)) + Numbers.randomDouble() * (double)this.xSpread.get(data) * 2.0, (double)this.vSpread.get(data) + Numbers.randomDouble() * (double)this.vSpread.get(data) * 2.0, (double)(0.0f - this.zSpread.get(data)) + Numbers.randomDouble() * (double)this.zSpread.get(data) * 2.0);
                new ParticleMaker.ParticlePacket(this.strParticle, direction, this.pSpeed.get(data), 1, true).send(ln, this.viewDistance);
            }
        }
    }
}

