/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.adapters.BukkitParticle;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.ParticleMaker;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.awt.Color;
import java.io.File;
import java.util.Collection;

@MythicMechanic(author="Ashijin", name="effect:particles", aliases={"effect:particle", "particles", "particle", "e:particles", "e:particle", "e:p"}, description="Plays a particle effect at the target location")
public class ParticleEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected String strParticle;
    protected String strMob;
    protected BukkitEntityType me;
    protected MythicMob mm;
    protected boolean isMob;
    protected BukkitParticle particle;
    protected Object particleData = null;
    protected SkillAudience audience;
    protected PlaceholderFloat xSpread;
    protected PlaceholderFloat zSpread;
    protected PlaceholderFloat vSpread;
    protected PlaceholderFloat pSpeed;
    protected PlaceholderFloat yOffset;
    protected float startForwardOffset;
    protected float startSideOffset;
    protected boolean useEyeLocation;
    protected PlaceholderInt amount;
    protected int viewDistance;
    protected boolean directional;
    protected boolean directionReversed;
    protected AbstractVector direction;
    protected float yaw;
    protected float pitch;
    protected boolean setYaw = false;
    protected boolean setPitch = false;
    protected boolean exactOffsets = false;
    protected Color color = null;
    boolean fromOrigin;

    @Deprecated
    public ParticleEffect(SkillExecutor manager, String file, MythicLineConfig mlc) {
        this(manager, new File(file), mlc.getLine(), mlc);
    }

    public ParticleEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        String strColor;
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.strParticle = mlc.getString(new String[]{"particle", "p"}, "reddust", new String[0]);
        this.strMob = mlc.getString(new String[]{"mob", "m", "t"}, "null", new String[0]);
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            if (!this.strParticle.equals("mob")) {
                this.isMob = false;
                this.particle = BukkitParticle.get(this.strParticle);
                if (this.particle.requiresData()) {
                    this.particleData = this.particle.parseDataOptions(mlc);
                }
            } else {
                this.isMob = true;
                this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
                ((MythicBukkit)this.getPlugin()).getSkillManager().queueSecondPass(() -> {
                    this.mm = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMob(this.strMob).orElseGet(() -> null);
                    if (this.mm == null) {
                        this.me = BukkitEntityType.getMythicEntity(this.strMob);
                        if (this.me == null) {
                            MythicLogger.errorMechanicConfig(this, mlc, "The 'Mob' attribute must be a valid MythicMob or MythicEntity type.");
                        }
                    }
                });
            }
        }
        this.audience = mlc.getAudience("audience", "world");
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a", "count"}, 10, new String[0]);
        String spread = mlc.getString(new String[]{"spread", "offset"}, "0", new String[0]);
        String hSpread = mlc.getString(new String[]{"hspread", "hs"}, spread, new String[0]);
        this.xSpread = PlaceholderFloat.of(mlc.getString(new String[]{"xspread", "xs"}, hSpread, new String[0]));
        this.zSpread = PlaceholderFloat.of(mlc.getString(new String[]{"zspread", "zs"}, hSpread, new String[0]));
        this.vSpread = mlc.getPlaceholderFloat(new String[]{"vspread", "vs", "yspread", "ys"}, spread, new String[0]);
        this.pSpeed = mlc.getPlaceholderFloat(new String[]{"speed", "s"}, 0.0f, new String[0]);
        this.yOffset = mlc.getPlaceholderFloat(new String[]{"yoffset", "y"}, 0.0f, new String[0]);
        this.startForwardOffset = mlc.getFloat(new String[]{"forwardoffset", "startfoffset", "sfo"}, 0.0f);
        this.startSideOffset = mlc.getFloat(new String[]{"sideoffset", "soffset", "sso"}, 0.0f);
        this.useEyeLocation = mlc.getBoolean(new String[]{"useeyelocation", "uel"}, false);
        this.exactOffsets = mlc.getBoolean(new String[]{"exactoffsets", "eo"}, false);
        this.viewDistance = mlc.getInteger(new String[]{"viewdistance", "vd"}, 128);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.directional = mlc.getBoolean(new String[]{"directional", "d"}, false);
        this.directionReversed = mlc.getBoolean(new String[]{"directionreversed", "dr"}, false);
        String direction = mlc.getString(new String[]{"direction", "dir"}, null, new String[0]);
        if (direction == null) {
            this.direction = null;
        } else {
            try {
                String[] split = direction.split(",");
                double dx = Double.parseDouble(split[0]);
                double dy = Double.parseDouble(split[1]);
                double dz = Double.parseDouble(split[2]);
                this.direction = new AbstractVector(dx, dy, dz);
            }
            catch (Error | Exception ex) {
                MythicLogger.errorMechanicConfig(this, mlc, "Invalid format for direction: must be x,y,z vector");
            }
        }
        this.yaw = mlc.getFloat(new String[]{"fixedyaw", "yaw"}, -1111.0f);
        if (this.yaw != -1111.0f) {
            this.setYaw = true;
        }
        this.pitch = mlc.getFloat(new String[]{"fixedpitch", "pitch"}, -1111.0f);
        if (this.pitch != -1111.0f) {
            this.setPitch = true;
        }
        this.color = (strColor = mlc.getString(new String[]{"color", "c"}, null, new String[0])) == null ? null : Color.decode(strColor);
        this.startForwardOffset *= -1.0f;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, null);
        this.playEffect(data, target, audience);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        AbstractLocation startLocation = this.useEyeLocation ? target.getEyeLocation() : target.getLocation();
        Collection<AbstractPlayer> audience = this.audience.get(data, target);
        this.playEffect(data, startLocation, audience);
        return SkillResult.SUCCESS;
    }

    protected void playEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractPlayer> audience) {
        if (this.setYaw) {
            target.setYaw(this.yaw);
        }
        if (this.setPitch) {
            target.setPitch(this.pitch);
        }
        if (this.startForwardOffset != 0.0f) {
            target = MythicUtil.move(target, this.startForwardOffset, 0.0, 0.0);
        }
        if (this.startSideOffset != 0.0f) {
            target = MythicUtil.move(target, 0.0, 0.0, this.startSideOffset);
        }
        if (this.directional) {
            this.playDirectionalParticleEffect(data, data.getOrigin(), target, audience);
        } else {
            this.playParticleEffect(data, target, audience);
        }
    }

    protected void playParticleEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractPlayer> audience) {
        AbstractLocation ln = target.clone().add(0.0, this.yOffset.get(data), 0.0);
        if (!this.isMob) {
            if (this.particleData == null) {
                if (this.color != null) {
                    this.particle.sendLegacyColored(audience, ln, this.pSpeed.get(data), this.amount.get(data), this.xSpread.get(data), this.vSpread.get(data), this.zSpread.get(data), this.color);
                } else {
                    this.particle.send(audience, ln, this.pSpeed.get(data), this.amount.get(data), this.xSpread.get(data), this.vSpread.get(data), this.zSpread.get(data));
                }
            } else {
                this.particle.send(audience, ln, this.pSpeed.get(data), this.amount.get(data), this.xSpread.get(data), this.vSpread.get(data), this.zSpread.get(data), this.particleData, this.exactOffsets);
            }
        } else {
            ln.add(Math.random() * (double)this.xSpread.get(data) * 2.0 - (double)this.xSpread.get(data), Math.random() * (double)this.vSpread.get(data) * 2.0 - (double)this.vSpread.get(data), Math.random() * (double)this.zSpread.get(data) * 2.0 - (double)this.zSpread.get(data));
            Schedulers.sync().run(() -> MythicBukkit.inst().getMobManager().spawnMob(this.strMob, ln));
        }
    }

    protected void playColoredParticleEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractPlayer> audience) {
        int amount = this.amount.get(data);
        for (int i = 0; i < amount; ++i) {
            AbstractLocation ln = target.clone().add((double)(0.0f - this.xSpread.get(data)) + Numbers.randomDouble() * (double)this.xSpread.get(data) * 2.0, (double)(this.yOffset.get(data) - this.vSpread.get(data)) + Numbers.randomDouble() * (double)this.vSpread.get(data) * 2.0, (double)(0.0f - this.zSpread.get(data)) + Numbers.randomDouble() * (double)this.zSpread.get(data) * 2.0);
            new ParticleMaker.ParticlePacket(this.strParticle, this.color, this.pSpeed.get(data), 1, true).send(ln, this.viewDistance);
        }
    }

    protected void playDirectionalParticleEffect(SkillMetadata data, AbstractLocation origin, AbstractLocation target, Collection<AbstractPlayer> audience) {
        AbstractLocation spawnLocation;
        AbstractVector direction;
        if (this.direction != null) {
            direction = this.direction;
            spawnLocation = target;
        } else if (this.directionReversed) {
            direction = origin.toVector().subtract(target.clone().toVector()).normalize();
            spawnLocation = origin;
        } else {
            direction = target.toVector().subtract(origin.clone().toVector()).normalize();
            spawnLocation = origin;
        }
        if (this.particleData == null) {
            this.particle.sendDirectional(audience, spawnLocation, this.pSpeed.get(data), this.amount.get(data), this.xSpread.get(data), this.vSpread.get(data), this.zSpread.get(data), direction);
        }
    }
}

