/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.projectiles.ProjectileHitBox;
import io.lumine.mythic.core.utils.VectorUtils;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

@MythicMechanic(author="Ashijin", name="orbital", aliases={"o"}, description="Applies an orbital aura to the target")
public class OrbitalMechanic
extends Aura
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    public static final Set<AbstractEntity> BULLET_ENTITIES = ConcurrentHashMap.newKeySet();
    @MythicField(name="radius", aliases={"r"}, description="The radius of the orbital aura")
    protected PlaceholderFloat radius;
    @MythicField(name="hitRadius", aliases={"hr"}, description="The hit radius of the orbital aura")
    protected float hitRadius;
    @MythicField(name="verticalHitRadius", aliases={"vhr", "vr"}, description="The vertical hit radius of the orbital aura")
    protected float verticalHitRadius;
    @MythicField(name="points", aliases={"p"}, description="The number of points in the orbital aura")
    protected PlaceholderInt points;
    @MythicField(name="interval", description="The interval between iterations of the orbital aura")
    protected int interval;
    @MythicField(name="iterations", description="The number of iterations of the orbital aura")
    protected int iterations;
    @MythicField(name="velocity", description="The velocity of the orbital aura")
    protected double velocity;
    @MythicField(name="rotate", description="Whether the orbital aura should rotate")
    protected boolean rotate;
    @MythicField(name="startingStep", aliases={"sp"}, description="The starting step of the orbital aura")
    protected PlaceholderInt startingStep;
    @MythicField(name="xRotation", aliases={"rotx", "rx"}, description="The X rotation of the orbital aura")
    protected PlaceholderDouble xRotation;
    @MythicField(name="yRotation", aliases={"roty", "ry"}, description="The Y rotation of the orbital aura")
    protected PlaceholderDouble yRotation;
    @MythicField(name="zRotation", aliases={"rotz", "rz"}, description="The Z rotation of the orbital aura")
    protected PlaceholderDouble zRotation;
    @MythicField(name="xOffset", aliases={"offx", "ox"}, description="The X offset of the orbital aura")
    protected PlaceholderDouble xOffset;
    @MythicField(name="yOffset", aliases={"offy", "oy"}, description="The Y offset of the orbital aura")
    protected PlaceholderDouble yOffset;
    @MythicField(name="zOffset", aliases={"offz", "oz"}, description="The Z offset of the orbital aura")
    protected PlaceholderDouble zOffset;
    @MythicField(name="onHitSkill", aliases={"onhit", "oh"}, description="The name of the skill to trigger when the orbital aura hits a target")
    protected String onHitSkillName;
    protected Optional<Skill> onHitSkill = Optional.empty();
    @MythicField(name="hitSelf", aliases={"hs"}, description="Whether the orbital aura can hit the caster")
    protected boolean hitSelf;
    @MythicField(name="hitPlayers", aliases={"hp"}, description="Whether the orbital aura can hit players")
    protected boolean hitPlayers;
    @MythicField(name="hitNonPlayers", aliases={"hnp"}, description="Whether the orbital aura can hit non-players")
    protected boolean hitNonPlayers;
    @MythicField(name="bulletType", aliases={"bullet", "b"}, description="The type of bullet used by the orbital aura")
    protected BulletType bulletType;
    @MythicField(name="bulletMaterial", aliases={"material", "mat"}, description="The material of the bullet used by the orbital aura")
    protected Material bulletMaterial;
    @MythicField(name="bulletModelId", aliases={"bulletmodel", "model"}, description="The model ID of the bullet used by the orbital aura")
    protected int bulletModelId;
    @MythicField(name="bulletMythicItem", aliases={"bulletmaterial", "material", "mat"}, description="The MythicItem used as the bullet by the orbital aura")
    protected MythicItem bulletMythicItem;
    @MythicField(name="bulletProjectile", description="The projectile used as the bullet by the orbital aura")
    protected Projectile bulletProjectile;
    @MythicField(name="bulletMob", description="The MythicMob used as the bullet by the orbital aura")
    protected MythicMob bulletMob;
    @MythicField(name="bulletColor", description="The color of the bullet used by the orbital aura")
    protected String bulletColor;
    @MythicField(name="bulletEnchanted", aliases={"enchanted"}, description="Whether the bullet used by the orbital aura is enchanted")
    protected boolean bulletEnchanted;
    @MythicField(name="bulletSpin", aliases={"bspin"}, description="The spin of the bullet used by the orbital aura")
    protected float bulletSpin;
    @MythicField(name="bulletMatchDirection", description="Whether the bullet used by the orbital aura matches the direction")
    protected boolean bulletMatchDirection;
    protected double angularVelocityX = 0.015707963267948967;
    protected double angularVelocityY = 0.018479956785822312;
    protected double angularVelocityZ = 0.02026833970057931;

    public OrbitalMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.radius = mlc.getPlaceholderFloat(new String[]{"radius", "r"}, 4.0f, new String[0]);
        this.hitRadius = mlc.getFloat(new String[]{"hitradius", "hr"}, 1.0f);
        this.verticalHitRadius = mlc.getFloat(new String[]{"verticalhitradius", "vhr", "vr"}, this.hitRadius);
        this.points = mlc.getPlaceholderInteger(new String[]{"points", "p"}, 32, new String[0]);
        this.startingStep = mlc.getPlaceholderInteger(new String[]{"startingPoint", "sp"}, 0, new String[0]);
        this.xRotation = mlc.getPlaceholderDouble(new String[]{"rotationx", "rotx", "rx"}, 0.0, new String[0]);
        this.yRotation = mlc.getPlaceholderDouble(new String[]{"rotationy", "roty", "ry"}, 0.0, new String[0]);
        this.zRotation = mlc.getPlaceholderDouble(new String[]{"rotationz", "rotz", "rz"}, 0.0, new String[0]);
        this.xOffset = mlc.getPlaceholderDouble(new String[]{"offsetx", "offx", "ox"}, 0.0, new String[0]);
        this.yOffset = mlc.getPlaceholderDouble(new String[]{"offsety", "offy", "oy"}, 0.0, new String[0]);
        this.zOffset = mlc.getPlaceholderDouble(new String[]{"offsetz", "offz", "oz"}, 0.0, new String[0]);
        this.angularVelocityX = mlc.getDouble(new String[]{"angularvelocityx", "avx", "vx"}, 0.0);
        this.angularVelocityY = mlc.getDouble(new String[]{"angularvelocityy", "avy", "vy"}, 0.0);
        this.angularVelocityZ = mlc.getDouble(new String[]{"angularvelocityz", "avz", "vz"}, 0.0);
        this.angularVelocityX = this.angularVelocityX == 0.0 ? 0.0 : Math.PI / this.angularVelocityX;
        this.angularVelocityY = this.angularVelocityY == 0.0 ? 0.0 : Math.PI / this.angularVelocityY;
        this.angularVelocityZ = this.angularVelocityZ == 0.0 ? 0.0 : Math.PI / this.angularVelocityZ;
        this.rotate = mlc.getBoolean(new String[]{"rotate"}, this.angularVelocityX > 0.0 || this.angularVelocityY > 0.0 || this.angularVelocityZ > 0.0);
        this.hitSelf = mlc.getBoolean(new String[]{"hitself", "hs"}, false);
        this.hitPlayers = mlc.getBoolean(new String[]{"hitplayers", "hp"}, true);
        this.hitNonPlayers = mlc.getBoolean(new String[]{"hitnonplayers", "hnp"}, false);
        this.onHitSkillName = mlc.getString(new String[]{"onhitskill", "onhit", "oh"});
        String bulletType = mlc.getString(new String[]{"bullettype", "bullet", "b"}, "NONE", new String[0]);
        try {
            this.bulletType = BulletType.valueOf(bulletType.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid bullet type specified");
            this.bulletType = BulletType.NONE;
        }
        switch (this.bulletType) {
            case TRACKING: 
            case BLOCK: 
            case ITEM: 
            case SMALLBLOCK: {
                String strBulletMaterial = mlc.getString(new String[]{"bulletmaterial", "material", "mat"}, "STONE", new String[0]);
                try {
                    this.bulletMaterial = Material.valueOf((String)strBulletMaterial.toUpperCase());
                    this.bulletModelId = mlc.getInteger(new String[]{"bulletmodel", "model"}, 0);
                    this.bulletMatchDirection = mlc.getBoolean(new String[]{"bulletsmall"}, false);
                    this.bulletColor = mlc.getString(new String[]{"bulletcolor"}, null, new String[0]);
                    this.bulletEnchanted = mlc.getBoolean(new String[]{"bulletEnchanted", "enchanted"}, false);
                }
                catch (Exception ex) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Specified bullet material does not exist");
                    this.bulletMaterial = Material.STONE;
                }
                break;
            }
            case MYTHICITEM: {
                String strMythicItem = mlc.getString(new String[]{"bulletmaterial", "material", "mat"}, "STONE", new String[0]);
                Optional<MythicItem> maybeItem = MythicBukkit.inst().getItemManager().getItem(strMythicItem);
                maybeItem.ifPresent(mythicItem -> {
                    this.bulletMythicItem = mythicItem;
                });
                break;
            }
        }
        this.bulletSpin = mlc.getFloat(new String[]{"bulletspin", "bspin"}, 0.0f);
        this.getManager().queueSecondPass(() -> {
            if (this.onHitSkillName != null) {
                this.onHitSkill = this.getManager().getSkill(file, this, this.onHitSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded orbital onHit pointing at " + this.onHitSkillName, new Object[0]);
            if (this.bulletType == BulletType.MOB) {
                String mobType = mlc.getString(new String[]{"mob", "mobtype", "mm"}, "SkeletalKnight", new String[0]);
                this.bulletMob = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMob(mobType).orElseGet(() -> null);
                if (this.bulletMob == null) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Invalid bullet mob type " + mobType + " specified");
                    this.bulletType = BulletType.NONE;
                }
            }
        });
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        new OrbitalTracker(data, target);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new OrbitalTracker(data, target);
        return SkillResult.SUCCESS;
    }

    protected static enum BulletType {
        NONE,
        TRACKING,
        ITEM,
        BLOCK,
        SMALLBLOCK,
        MYTHICITEM,
        ARMOR_STAND,
        ARROW,
        MOB;

    }

    public class OrbitalTracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable {
        private float radius;
        private float power;
        private int iteration;
        private int step;
        protected double xRotation;
        protected double yRotation;
        protected double zRotation;
        protected AbstractLocation currentLocation;
        protected AbstractLocation previousLocation;
        protected AbstractEntity bullet;
        private Set<AbstractEntity> inRange;
        private HashSet<AbstractEntity> targets;
        private Map<AbstractEntity, Long> immune;

        public OrbitalTracker(SkillMetadata data, AbstractEntity entity) {
            super(entity, data);
            this.iteration = 0;
            this.step = 0;
            this.xRotation = 0.0;
            this.yRotation = 0.0;
            this.zRotation = 0.0;
            this.bullet = null;
            this.inRange = ConcurrentHashMap.newKeySet();
            this.targets = new HashSet();
            this.immune = new HashMap<AbstractEntity, Long>();
            this.step = OrbitalMechanic.this.startingStep.get(data);
            this.radius = OrbitalMechanic.this.radius.get(data);
            this.power = data.getPower();
            this.xRotation = OrbitalMechanic.this.xRotation.get(data, entity);
            this.yRotation = OrbitalMechanic.this.yRotation.get(data, entity);
            this.zRotation = OrbitalMechanic.this.zRotation.get(data, entity);
            this.start();
        }

        public OrbitalTracker(SkillMetadata data, AbstractLocation location) {
            super(location, data);
            this.iteration = 0;
            this.step = 0;
            this.xRotation = 0.0;
            this.yRotation = 0.0;
            this.zRotation = 0.0;
            this.bullet = null;
            this.inRange = ConcurrentHashMap.newKeySet();
            this.targets = new HashSet();
            this.immune = new HashMap<AbstractEntity, Long>();
            this.step = OrbitalMechanic.this.startingStep.get(data);
            this.radius = OrbitalMechanic.this.radius.get(data);
            this.power = data.getPower();
            this.xRotation = OrbitalMechanic.this.xRotation.get(data);
            this.yRotation = OrbitalMechanic.this.yRotation.get(data);
            this.zRotation = OrbitalMechanic.this.zRotation.get(data);
            this.start();
        }

        public AbstractLocation getLocation() {
            AbstractLocation loc = null;
            if (this.entity.isPresent()) {
                loc = ((AbstractEntity)this.entity.get()).getLocation().add(OrbitalMechanic.this.xOffset.get(this.getSkillMetadata()), OrbitalMechanic.this.yOffset.get(this.getSkillMetadata()), OrbitalMechanic.this.zOffset.get(this.getSkillMetadata()));
            } else if (this.location.isPresent()) {
                loc = ((AbstractLocation)this.location.get()).clone().add(OrbitalMechanic.this.xOffset.get(this.getSkillMetadata()), OrbitalMechanic.this.yOffset.get(this.getSkillMetadata()), OrbitalMechanic.this.zOffset.get(this.getSkillMetadata()));
            }
            return loc;
        }

        @Override
        public void auraStart() {
            if (OrbitalMechanic.this.hitSelf || OrbitalMechanic.this.hitPlayers || OrbitalMechanic.this.hitNonPlayers) {
                this.inRange.addAll(((MythicBukkit)OrbitalMechanic.this.getPlugin()).getEntityManager().getLivingEntities(this.skillMetadata.getOrigin().getWorld()));
                this.inRange.removeIf(e -> {
                    if (e != null) {
                        if (!OrbitalMechanic.this.hitSelf && e.getUniqueId().equals(this.skillMetadata.getCaster().getEntity().getUniqueId())) {
                            return true;
                        }
                        if (!OrbitalMechanic.this.hitPlayers && e.isPlayer()) {
                            return true;
                        }
                        return !OrbitalMechanic.this.hitNonPlayers && !e.isPlayer();
                    }
                    return true;
                });
            }
            if (this.previousLocation == null) {
                this.previousLocation = this.getLocation();
                double inc = Math.PI * 2 / (double)OrbitalMechanic.this.points.get(this.skillMetadata);
                double angle = (double)this.step * inc;
                AbstractVector v = new AbstractVector(0, 0, 0);
                v.setX(Math.cos(angle) * (double)this.radius);
                v.setZ(Math.sin(angle) * (double)this.radius);
                VectorUtils.rotateVector(v, this.xRotation, this.yRotation, this.zRotation);
                if (OrbitalMechanic.this.rotate) {
                    VectorUtils.rotateVector(v, OrbitalMechanic.this.angularVelocityX * (double)this.step, OrbitalMechanic.this.angularVelocityY * (double)this.step, OrbitalMechanic.this.angularVelocityZ * (double)this.step);
                }
                this.previousLocation.add(v);
            }
            this.spawnBullet();
            this.executeAuraSkill(OrbitalMechanic.this.onStartSkill, this.skillMetadata.deepClone().setOrigin(this.previousLocation));
        }

        @Override
        public void auraTick() {
            this.previousLocation = this.previousLocation == null ? this.getLocation() : this.currentLocation;
            AbstractLocation location = this.getLocation();
            double inc = Math.PI * 2 / (double)OrbitalMechanic.this.points.get(this.skillMetadata);
            double angle = (double)this.step * inc;
            AbstractVector v = new AbstractVector(0, 0, 0);
            v.setX(Math.cos(angle) * (double)this.radius);
            v.setZ(Math.sin(angle) * (double)this.radius);
            VectorUtils.rotateVector(v, this.xRotation, this.yRotation, this.zRotation);
            if (OrbitalMechanic.this.rotate) {
                VectorUtils.rotateVector(v, OrbitalMechanic.this.angularVelocityX * (double)this.step, OrbitalMechanic.this.angularVelocityY * (double)this.step, OrbitalMechanic.this.angularVelocityZ * (double)this.step);
            }
            this.currentLocation = location.add(v);
            this.executeAuraSkill(OrbitalMechanic.this.onTickSkill, this.skillMetadata.deepClone().setOrigin(this.currentLocation).setLocationTarget(this.currentLocation));
            AbstractLocation fLocation = location;
            Schedulers.sync().run(() -> {
                if (this.bullet != null) {
                    if (OrbitalMechanic.this.bulletType == BulletType.TRACKING) {
                        this.orientBulletArmorStand();
                    } else if (OrbitalMechanic.this.bulletType == BulletType.ITEM) {
                        AbstractLocation ol = this.previousLocation == null ? this.currentLocation.clone().subtract(0.0, 0.35, 0.0) : this.previousLocation.clone().subtract(0.0, 0.35, 0.0);
                        ((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, ol);
                        this.bullet.setVelocity(fLocation.toVector().subtract(this.previousLocation.toVector()));
                    } else if (OrbitalMechanic.this.bulletType == BulletType.ARROW) {
                        this.bullet.setVelocity(fLocation.toVector().subtract(this.bullet.getLocation().clone().toVector()).multiply(0.25));
                    } else if (OrbitalMechanic.this.bulletType == BulletType.MOB) {
                        AbstractLocation ol = this.previousLocation == null ? this.currentLocation.clone().subtract(0.0, 1.35, 0.0) : this.previousLocation.clone().subtract(0.0, 1.35, 0.0);
                        if (OrbitalMechanic.this.bulletSpin != 0.0f) {
                            float newSpin = this.bullet.getLocation().getYaw() + OrbitalMechanic.this.bulletSpin;
                            ol.setYaw(newSpin);
                        }
                        this.bullet.teleport(ol);
                    } else {
                        this.bullet.setVelocity(fLocation.toVector().subtract(this.bullet.getLocation().clone().toVector()).multiply(1));
                        if (OrbitalMechanic.this.bulletSpin > 0.0f) {
                            float newSpin = this.bullet.getLocation().getYaw() + OrbitalMechanic.this.bulletSpin;
                            ((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setEntityRotation(this.bullet, newSpin, newSpin);
                        }
                    }
                }
            });
            if (this.inRange != null) {
                ProjectileHitBox hitBox = new ProjectileHitBox(location, OrbitalMechanic.this.hitRadius, OrbitalMechanic.this.verticalHitRadius);
                for (AbstractEntity e : this.inRange) {
                    if (e.isDead() || !hitBox.contains(e.getLocation().add(0.0, 0.6, 0.0))) continue;
                    this.targets.add(e);
                    this.immune.put(e, System.currentTimeMillis());
                    break;
                }
                this.immune.entrySet().removeIf(entry -> (Long)entry.getValue() < System.currentTimeMillis() - 2000L);
                if (!this.targets.isEmpty()) {
                    if (OrbitalMechanic.this.onHitSkill.isPresent()) {
                        SkillMetadata sData = this.skillMetadata.deepClone();
                        sData.setEntityTargets((HashSet)this.targets.clone());
                        sData.setOrigin(this.currentLocation.clone());
                        if (OrbitalMechanic.this.onHitSkill.get().isUsable(sData)) {
                            OrbitalMechanic.this.onHitSkill.get().execute(sData);
                        }
                    }
                    this.targets.clear();
                    this.consumeCharge();
                }
            }
            ++this.step;
        }

        @Override
        public void auraStop() {
            this.executeAuraSkill(OrbitalMechanic.this.onEndSkill, this.skillMetadata.deepClone().setOrigin(this.previousLocation));
            if (OrbitalMechanic.this.bulletType != BulletType.NONE) {
                Schedulers.sync().runLater(() -> {
                    if (this.bullet != null) {
                        this.bullet.remove();
                        BULLET_ENTITIES.remove(this.bullet);
                    }
                }, 2L);
            }
        }

        private void spawnBullet() {
            if (OrbitalMechanic.this.bulletType == BulletType.TRACKING) {
                Schedulers.sync().run(() -> {
                    ArmorStand armorStand;
                    if (this.hasTerminated()) {
                        return;
                    }
                    AbstractLocation l = this.getLocation().clone().subtract(0.0, 1.4375, 0.0);
                    Location location = BukkitAdapter.adapt(l);
                    if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
                        armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND, CreatureSpawnEvent.SpawnReason.CUSTOM, entity -> {
                            ArmorStand as = (ArmorStand)entity;
                            as.setInvisible(true);
                            as.setAI(true);
                            as.setTicksLived(Integer.MAX_VALUE);
                            as.setInvulnerable(true);
                            as.setGravity(false);
                            as.setRemoveWhenFarAway(true);
                        });
                    } else {
                        armorStand = (ArmorStand)((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getWorldHandler().spawnInvisibleArmorStand(location);
                        armorStand.setInvisible(true);
                        armorStand.setAI(true);
                        armorStand.setTicksLived(Integer.MAX_VALUE);
                        armorStand.setInvulnerable(true);
                        armorStand.setGravity(false);
                        armorStand.setRemoveWhenFarAway(true);
                    }
                    ItemFactory bulletItem = ItemFactory.of(OrbitalMechanic.this.bulletMaterial).model(OrbitalMechanic.this.bulletModelId);
                    if (OrbitalMechanic.this.bulletColor != null) {
                        bulletItem.color(OrbitalMechanic.this.bulletColor);
                    }
                    if (OrbitalMechanic.this.bulletEnchanted) {
                        bulletItem.enchant(Enchantment.VANISHING_CURSE);
                    }
                    armorStand.getEquipment().setHelmet(bulletItem.build());
                    this.bullet = BukkitAdapter.adapt((Entity)armorStand);
                    BULLET_ENTITIES.add(this.bullet);
                    ((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0);
                    if (this.hasTerminated()) {
                        armorStand.remove();
                    }
                });
            } else if (OrbitalMechanic.this.bulletType == BulletType.BLOCK) {
                Schedulers.sync().run(() -> {
                    if (this.hasTerminated()) {
                        return;
                    }
                    AbstractLocation l = this.getLocation().clone().subtract(0.0, 0.5, 0.0);
                    FallingBlock block = ServerVersion.isAfterOrEq(MinecraftVersions.v1_15) ? BukkitAdapter.adapt(l).getWorld().spawnFallingBlock(BukkitAdapter.adapt(l), OrbitalMechanic.this.bulletMaterial.createBlockData()) : BukkitAdapter.adapt(l).getWorld().spawnFallingBlock(BukkitAdapter.adapt(l), OrbitalMechanic.this.bulletMaterial, (byte)0);
                    block.setHurtEntities(false);
                    block.setDropItem(false);
                    block.setTicksLived(Integer.MAX_VALUE);
                    block.setInvulnerable(true);
                    block.setGravity(false);
                    this.bullet = BukkitAdapter.adapt((Entity)block);
                    BULLET_ENTITIES.add(this.bullet);
                    ((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0);
                    if (this.hasTerminated()) {
                        block.remove();
                    }
                });
            } else if (OrbitalMechanic.this.bulletType == BulletType.MYTHICITEM) {
                Schedulers.sync().run(() -> {
                    ItemStack i = BukkitAdapter.adapt(OrbitalMechanic.this.bulletMythicItem.generateItemStack(1));
                    AbstractLocation l = this.getLocation().clone().subtract(0.0, 0.35, 0.0);
                    Item item = BukkitAdapter.adapt(l).getWorld().dropItem(BukkitAdapter.adapt(l), i);
                    item.setTicksLived(Integer.MAX_VALUE);
                    item.setInvulnerable(true);
                    item.setGravity(false);
                    item.setPickupDelay(Integer.MAX_VALUE);
                    this.bullet = BukkitAdapter.adapt((Entity)item);
                    BULLET_ENTITIES.add(this.bullet);
                    ((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, l);
                    ((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().sendEntityTeleportPacket(this.bullet);
                    ((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0);
                    if (this.hasTerminated()) {
                        item.remove();
                    }
                });
            } else if (OrbitalMechanic.this.bulletType == BulletType.SMALLBLOCK) {
                Schedulers.sync().run(() -> {
                    AbstractLocation l = this.getLocation().clone();
                    ArmorStand block = (ArmorStand)BukkitAdapter.adapt(l).getWorld().spawnEntity(BukkitAdapter.adapt(l), EntityType.ARMOR_STAND);
                    block.setCustomName("Dinnerbone");
                    block.setCustomNameVisible(false);
                    block.setHeadPose(new EulerAngle(0.0, 0.0, 0.0));
                    block.getEquipment().setHelmet(new ItemStack(OrbitalMechanic.this.bulletMaterial));
                    block.setArms(false);
                    block.setBasePlate(false);
                    block.setVisible(false);
                    block.setTicksLived(Integer.MAX_VALUE);
                    block.setInvulnerable(true);
                    this.bullet = BukkitAdapter.adapt((Entity)block);
                    ((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setArmorStandNoGravity(this.bullet);
                    BULLET_ENTITIES.add(this.bullet);
                    ((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0);
                    if (this.hasTerminated()) {
                        block.remove();
                    }
                });
            } else if (OrbitalMechanic.this.bulletType == BulletType.ITEM) {
                Schedulers.sync().run(() -> {
                    ItemStack i = ItemFactory.of(OrbitalMechanic.this.bulletMaterial).model(OrbitalMechanic.this.bulletModelId).build();
                    AbstractLocation l = this.getLocation().clone().subtract(0.0, 0.35, 0.0);
                    Item item = BukkitAdapter.adapt(l).getWorld().dropItem(BukkitAdapter.adapt(l), i);
                    item.setTicksLived(Integer.MAX_VALUE);
                    item.setInvulnerable(true);
                    item.setGravity(false);
                    item.setPickupDelay(Integer.MAX_VALUE);
                    this.bullet = BukkitAdapter.adapt((Entity)item);
                    BULLET_ENTITIES.add(this.bullet);
                    ((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, l);
                    ((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().sendEntityTeleportPacket(this.bullet);
                    ((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0);
                    if (this.hasTerminated()) {
                        item.remove();
                    }
                });
            } else if (OrbitalMechanic.this.bulletType == BulletType.MOB && OrbitalMechanic.this.bulletMob != null) {
                Schedulers.sync().runLater(() -> {
                    AbstractLocation l = this.getLocation().clone().subtract(0.0, 1.35, 0.0);
                    ActiveMob am = OrbitalMechanic.this.bulletMob.spawn(l, 1.0, SpawnReason.OTHER);
                    if (am == null) {
                        return;
                    }
                    Entity entity = am.getEntity().getBukkitEntity();
                    am.setParent(this.skillMetadata.getCaster());
                    am.setOwner(this.skillMetadata.getCaster().getEntity().getUniqueId());
                    entity.setTicksLived(Integer.MAX_VALUE);
                    entity.setInvulnerable(true);
                    this.bullet = BukkitAdapter.adapt(entity);
                    BULLET_ENTITIES.add(this.bullet);
                    if (entity.getType().equals((Object)EntityType.ARMOR_STAND)) {
                        ((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setArmorStandNoGravity(this.bullet);
                        this.bullet.setAI(true);
                        ((ArmorStand)entity).setRemoveWhenFarAway(true);
                    } else {
                        entity.setGravity(false);
                        if (entity instanceof LivingEntity) {
                            ((LivingEntity)entity).setRemoveWhenFarAway(true);
                        }
                    }
                    ((MythicBukkit)OrbitalMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0);
                    if (this.hasTerminated()) {
                        this.bullet.remove();
                    }
                }, 2L);
            }
        }

        public void setRadius(float p) {
            this.radius = p;
        }

        public void multiplyRadius(float p) {
            this.radius *= p;
        }

        public void addRadius(float p) {
            this.radius += p;
        }

        protected void orientBulletArmorStand() {
            if (this.bullet == null) {
                Log.info("bullet null");
                return;
            }
            if (this.previousLocation == null) {
                Log.info("prev null");
                return;
            }
            if (!(this.bullet.getBukkitEntity() instanceof ArmorStand)) {
                Log.info("as");
                return;
            }
            ArmorStand stand = (ArmorStand)this.bullet.getBukkitEntity();
            Location from = BukkitAdapter.adapt(this.previousLocation).clone();
            Location to = BukkitAdapter.adapt(this.currentLocation).clone();
            Vector delta = to.toVector().subtract(from.toVector());
            double yaw = Math.atan2(delta.getX(), delta.getZ());
            double len = delta.getZ() / Math.cos(yaw);
            double pitch = Math.atan2(delta.getY(), len);
            stand.setHeadPose(new EulerAngle(-pitch, 0.0, 0.0));
            Location loc = to.clone().subtract(0.0, 1.4375, 0.0);
            loc.setYaw((float)Math.toDegrees(-yaw));
            stand.teleport(loc);
        }
    }
}

