/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.holograms.Hologram;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Collections;

@MythicMechanic(author="Joshinn", name="hologram", aliases={"summonhologram", "holo"}, description="Spawns a hologram at a target location.")
public class HologramMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    @MythicField(name="text", aliases={"t"}, description="The text of the hologram", defValue="Hologram Text Missing")
    protected PlaceholderString holoText;
    @MythicField(name="stayTime", aliases={"time", "stay"}, description="The duration of the hologram", defValue="100")
    protected Integer stayTime;

    public HologramMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.holoText = mlc.getPlaceholderString(new String[]{"text", "t"}, "Hologram Text Missing", new String[0]);
        this.stayTime = mlc.getInteger(new String[]{"staytime", "stay", "time"}, 100);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(data, target, target.getLocation());
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(data, null, target);
        return SkillResult.SUCCESS;
    }

    protected void playEffect(SkillMetadata data, AbstractEntity target, AbstractLocation l) {
        String texts = target == null ? this.holoText.get(data) : this.holoText.get(data, target);
        Hologram h2 = Hologram.create(l.toPosition(), Collections.singletonList(this.holoText.get(data)));
        h2.spawn();
        if (this.stayTime != null) {
            Schedulers.sync().runLater(() -> {
                h2.terminate();
                h2.despawn();
            }, this.stayTime.intValue());
        }
    }
}

